<?php
/**
 * Created by PhpStorm.
 * User: Dungdt
 * Date: 12/15/2015
 * Time: 3:19 PM
 */


if (!class_exists('ST_Payu_Payment_Gateway')) {
    class ST_Payu_Payment_Gateway extends STAbstactPaymentGateway
    {
        static private $_ints;
        private $default_status = true;
        private $_gatewayObject = null;
        private $_gateway_id = 'st_payu';

        function __construct()
        {
            add_filter('st_payment_gateway_st_payu_name', array($this, 'get_name'));
            add_action('admin_notices', array($this, '_add_notices'));
            add_action('admin_init', array($this, '_dismis_notice'));
        }

        function _dismis_notice()
        {
            if (STInput::get('st_dismiss_payu_notice')) {
                update_option('st_dismiss_payu_notice', 1);
            }

        }

        function init()
        {
            require_once Traveler_Payu_Payment::get_inst()->pluginPath . '/libraries/vendor/autoload.php';

            if (st()->get_option('payu_enable_sandbox', 'on') == 'on') {
                OpenPayU_Configuration::setEnvironment('sandbox');
            } else {
                OpenPayU_Configuration::setEnvironment('secure');
            }
            //set Production Environment


            //set POS ID and Second MD5 Key (from merchant admin panel)
            OpenPayU_Configuration::setMerchantPosId(st()->get_option('payu_post_id'));
            OpenPayU_Configuration::setSignatureKey(st()->get_option('payu_signature_key'));

            //set Oauth Client Id and Oauth Client Secret (from merchant admin panel)
            OpenPayU_Configuration::setOauthClientId(st()->get_option('payu_oauth_client_id'));
            OpenPayU_Configuration::setOauthClientSecret(st()->get_option('payu_oauth_client_secret'));
        }

        function _add_notices()
        {
            if (get_option('st_dismiss_payu_notice')) {
                return;
            }

            if (class_exists('STTravelCode')) {
                if (isset(STTravelCode::$plugins_data['Version'])) {
                    $version = STTravelCode::$plugins_data['Version'];
                    if (version_compare('1.3.2', $version, '>')) {
                        $url = admin_url('plugin-install.php?tab=plugin-information&plugin=traveler-code&TB_iframe=true&width=753&height=350');
                        ?>
                        <div class="error settings-error notice is-dismissible">
                            <p class=""><strong><?php _e('Traveler Notice:', 'traveler-payu') ?></strong></p>
                            <p>
                                <?php printf(__('<strong>Payu</strong> require %s version %s or above. Your current is %s', 'traveler-payu'), '<strong><em>' . __('Traveler Code', 'traveler-payu') . '</em></strong>', '<strong>1.3.2</strong>', '<strong>' . $version . '</strong>'); ?>
                            </p>
                            <p>
                                <a href="http://shinetheme.com/demosd/documentation/how-to-update-the-theme-2/"
                                   target="_blank"><?php _e('Learn how to update it', 'traveler-payu') ?></a>
                                |
                                <a href="<?php echo admin_url('index.php?st_dismiss_payu_notice=1') ?>"
                                   class="dismiss-notice"
                                   target="_parent"><?php _e('Dismiss this notice', 'traveler-payu') ?></a>
                            </p>
                            <button type="button" class="notice-dismiss"><span
                                        class="screen-reader-text"><?php _e('Dismiss this notice', 'traveler-payu') ?>
                                    .</span></button>
                        </div>
                        <?php
                    }
                }
            }
        }

        function get_option_fields()
        {
            return array(
                array(
                    'id' => 'payu_post_id',
                    'label' => __('POST ID', 'traveler-payu'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Your Payu POST ID', 'traveler-payu'),
                    'condition' => 'pm_gway_st_payu_enable:is(on)'
                ),
                array(
                    'id' => 'payu_signature_key',
                    'label' => __('Signature Key', 'traveler-payu'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Your Payu Signature Key', 'traveler-payu'),
                    'condition' => 'pm_gway_st_payu_enable:is(on)'
                ),
                array(
                    'id' => 'payu_oauth_client_id',
                    'label' => __('Oauth Client ID', 'traveler-payu'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Your Payu Oauth Client ID', 'traveler-payu'),
                    'condition' => 'pm_gway_st_payu_enable:is(on)'
                ),
                array(
                    'id' => 'payu_oauth_client_secret',
                    'label' => __('Oauth Client Secret', 'traveler-payu'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Your Payu Oauth Client Secret', 'traveler-payu'),
                    'condition' => 'pm_gway_st_payu_enable:is(on)'
                ),
                array(
                    'id' => 'payu_currency',
                    'label' => __('Currency', 'traveler-payu'),
                    'type' => 'select',
                    'choices' => [
                        [
                            'label' => 'PLN',
                            'value' => 'PLN'
                        ],
                        [
                            'label' => 'CZK',
                            'value' => 'CZK'
                        ],
                    ],
                    'section' => 'option_pmgateway',
                    'std' => 'PLN',
                    'desc' => __('Your Payu Currency ', 'traveler-payu'),
                    'condition' => 'pm_gway_st_payu_enable:is(on)'
                ),
                array(
                    'id' => 'payu_enable_sandbox',
                    'label' => __('Enable Test Mode', 'traveler-payu'),
                    'type' => 'on-off',
                    'section' => 'option_pmgateway',
                    'std' => 'on',
                    'desc' => __('Allow you to enable test mode', 'traveler-payu'),
                    'condition' => 'pm_gway_st_payu_enable:is(on)'
                ),
            );
        }

        function _pre_checkout_validate()
        {
            return true;
        }

        function do_checkout($order_id)
        {
            $this->init();

            $total = get_post_meta($order_id, 'total_price', true);
            $total = round((float)$total, 2);
            $purchase = [
                'customerIp' => $_SERVER['REMOTE_ADDR'],
                'description' => __('Order', 'traveler-payu'),
                'currencyCode' => st()->get_option('payu_currency', 'PLN'),
                'totalAmount' => (float)number_format((float)$total, 2, '', ''),
                'continueUrl' => $this->get_return_url($order_id),
                'notifyUrl' => $this->get_return_url($order_id),
                'extOrderId' => uniqid('', true),
                'merchantPosId' => OpenPayU_Configuration::getOauthClientId() ? OpenPayU_Configuration::getOauthClientId() : OpenPayU_Configuration::getMerchantPosId(),
                'buyer' => [
                    'email' => STInput::request('st_email'),
                    'phone' => STInput::request('st_phone'),
                    'firstName' => STInput::request('st_first_name'),
                    'lastName' => STInput::request('st_last_name'),
                    'language' => 'en'
                ],
                'products' => [
                    [
                        'name' => get_the_title($order_id),
                        'unitPrice' => number_format((float)$total, 2, '', ''),
                        'quantity' => 1
                    ]
                ]
            ];
            try {
                $response = OpenPayU_Order::create($purchase);
                $respon = $response->getResponse();
                if ($respon->redirectUri) {
                    return [
                        'status' => true,
                        'redirect' => $response->getResponse()->redirectUri
                    ];
                } else {
                    return [
                        'status' => false,
                        'message' => __('The payment is cancelled', 'traveler-payu')
                    ];
                }
            } catch (\Exception $e) {
                return ['status' => false, 'message' => $e->getMessage()];
            }
        }

        function package_do_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => __('This function is off', 'traveler-payu')];
            }

            $order = STAdminPackages::get_inst()->get('*', $order_id);
            $total = get_post_meta($order_id, 'total_price', TRUE);
            $total = round((float)$total, 2);
            $this->init();

            $order_token_code = $order->token;

            $purchase = [
                'customerIp' => $_SERVER['REMOTE_ADDR'],
                'description' => __('Member Package', 'traveler-payu'),
                'currencyCode' => st()->get_option('payu_currency', 'PLN'),
                'totalAmount' => round((float)$order->package_price, 2),
                'continueUrl' => STAdminPackages::get_inst()->get_return_url($order_id),
                'notifyUrl' => STAdminPackages::get_inst()->get_return_url($order_id),
                'extOrderId' => $order_token_code,
                'merchantPosId' => OpenPayU_Configuration::getOauthClientId() ? OpenPayU_Configuration::getOauthClientId() : OpenPayU_Configuration::getMerchantPosId(),
                'buyer' => [
                    'email' => STInput::request('st_email'),
                    'phone' => STInput::request('st_phone'),
                    'firstName' => STInput::request('st_first_name'),
                    'lastName' => STInput::request('st_last_name'),
                    'language' => 'en'
                ],
                'products' => [
                    [
                        'name' => get_the_title($order_id),
                        'unitPrice' => number_format((float)$total, 2, '', ''),
                        'quantity' => 1
                    ]
                ]
            ];
            try {
                $response = OpenPayU_Order::create($purchase);
                $respon = $response->getResponse();
                if ($respon->redirectUri) {
                    return [
                        'status' => TravelHelper::st_encrypt($order_id . 'st1'),
                        'redirect_url' => $response->getResponse()->redirectUri
                    ];
                } else {
                    return [
                        'status' => TravelHelper::st_encrypt($order_id . 'st0'),
                        'message' => __('The payment is cancelled', 'traveler-payu')
                    ];
                }
            } catch (\Exception $e) {
                return ['status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => $e->getMessage()];
            }
        }


        function check_complete_purchase($order_id)
        {
            if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                $this->init();
                $body = file_get_contents('php://input');
                $data = trim($body);
                try {
                    if (!empty($data)) {
                        $result = OpenPayU_Order::consumeNotification($data);
                    }
                    if ($result->getResponse()->order->orderId) {
                        $order = OpenPayU_Order::retrieve($result->getResponse()->order->orderId);
                        if ($order->getStatus() == 'SUCCESS') {
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } catch (OpenPayU_Exception $e) {
                    return false;
                }
            }
        }

        function package_completed_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => false];
            }
            if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                $this->init();
                $body = file_get_contents('php://input');
                $data = trim($body);
                try {
                    if (!empty($data)) {
                        $result = OpenPayU_Order::consumeNotification($data);
                    }
                    if ($result->getResponse()->order->orderId) {
                        $order = OpenPayU_Order::retrieve($result->getResponse()->order->orderId);
                        if ($order->getStatus() == 'SUCCESS') {
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        return false;
                    }
                } catch (OpenPayU_Exception $e) {
                    return false;
                }
            }
        }

        function html()
        {
            echo Traveler_Payu_Payment::get_inst()->loadTemplate('payu');
        }

        function get_name()
        {
            return __('Payu', 'traveler-payu');
        }

        function get_default_status()
        {
            return $this->default_status;
        }

        function is_available($item_id = false)
        {
            if (st()->get_option('pm_gway_st_payu_enable') == 'off') {
                return false;
            } else {
                if (!st()->get_option('payu_merchant_id')) {
                    return false;
                }
                if (!st()->get_option('payu_salt_key')) {
                    return false;
                }
            }

            if ($item_id) {
                $meta = get_post_meta($item_id, 'is_meta_payment_gateway_st_payu', true);
                if ($meta == 'off') {
                    return false;
                }
            }

            return true;
        }

        function getGatewayId()
        {
            return $this->_gateway_id;
        }

        function is_check_complete_required()
        {
            return true;
        }

        function get_logo()
        {
            return Traveler_Payu_Payment::get_inst()->pluginUrl . 'assets/img/pu-logo.png';
        }

        static function instance()
        {
            if (!self::$_ints) {
                self::$_ints = new self();
            }

            return self::$_ints;
        }

        static function add_payment($payment)
        {
            $payment['st_payu'] = self::instance();

            return $payment;
        }
    }

    add_filter('st_payment_gateways', array('ST_Payu_Payment_Gateway', 'add_payment'));
}