<?php
/**
 * Created by PhpStorm.
 * User: Dungdt
 * Date: 12/15/2015
 * Time: 3:19 PM
 */


if (!class_exists('ST_Onepay_Payment_Gateway')) {
    class ST_Onepay_Payment_Gateway extends STAbstactPaymentGateway
    {
        static private $_ints;
        private $default_status = true;
        private $_gatewayObject = null;
        private $_gateway_id = 'st_onepay';

        private $url;
        private $merchant_id;
        private $merchant_access_code;
        private $secure_secret;

        function __construct()
        {
            add_filter('st_payment_gateway_st_onepay_name', array($this, 'get_name'));
            try {
                $this->_gatewayObject = '';

            } catch (Exception $e) {
                $this->default_status = false;
            }
        }


        function get_option_fields()
        {
            return array(
                array(
                    'id' => 'onepay_creditcard_url',
                    'label' => __('URL', 'traveler-onepay'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => esc_html__( "Information connect or Environment test. Url for real: https://onepay.vn/vpcpay/vpcpay.op, Url for test: https://mtf.onepay.vn/vpcpay/vpcpay.op", 'traveler-onepay' ),
                    'condition' => 'pm_gway_st_onepay_enable:is(on)'
                ),
                array(
                    'id' => 'onepay_creditcard_merchant_id',
                    'label' => __('Merchant ID', 'traveler-onepay'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Merchant ID', 'traveler-onepay'),
                    'condition' => 'pm_gway_st_onepay_enable:is(on)'
                ),
                array(
                    'id' => 'onepay_creditcard_merchant_access_code',
                    'label' => __('Merchant Access Code', 'traveler-onepay'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Merchant Access Code', 'traveler-onepay'),
                    'condition' => 'pm_gway_st_onepay_enable:is(on)'
                ),
                array(
                    'id' => 'onepay_creditcard_secure_secret',
                    'label' => __('Security Secret', 'traveler-onepay'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Security Secret', 'traveler-onepay'),
                    'condition' => 'pm_gway_st_onepay_enable:is(on)'
                ),
            );
        }

        public function setDefaultParam()
        {
            $this->url = st()->get_option('onepay_creditcard_url', '');
            $this->merchant_id = st()->get_option('onepay_creditcard_merchant_id', '');
            $this->merchant_access_code = st()->get_option('onepay_creditcard_merchant_access_code', '');
            $this->secure_secret = st()->get_option('onepay_creditcard_secure_secret', '');
        }

        function _pre_checkout_validate()
        {
            if (TravelHelper::get_current_currency('name') != 'VND') {
                STTemplate::set_message(__('This payment only supports VND currency', 'traveler-onpepay'));
                return false;
            }

            return true;
        }

        function do_checkout($order_id)
        {
            if (!$this->is_available()) {
                return
                    [
                        'status' => 0,
                        'complete_purchase' => 0,
                        'error_type' => 'card_validate',
                        'error_fields' => '',
                    ];
            }

            $this->setDefaultParam();
            $lang = get_bloginfo("language"); // get current language of website
            if ($lang == "vi") {
                $vpc_Locale = "vn";
            } else $vpc_Locale = "en";

            $total = get_post_meta($order_id, 'total_price', true);
            $total = round((float)$total, 2);
            $total = number_format(1 * $total, 2, '.', '');
            $total = round($total, 2);

            $op_var = array(

                'AgainLink' => 'onepay.vn',
                'Title' => 'onepay.vn',
                'vpc_Locale' => $vpc_Locale,
                'vpc_Version' => '2',
                'vpc_Command' => 'pay',
                'vpc_Merchant' => $this->merchant_id,
                'vpc_AccessCode' => $this->merchant_access_code,
                'vpc_MerchTxnRef' => date('YmdHis') . rand(),
                'vpc_OrderInfo' => $order_id,
                'vpc_Amount' => $total * 100,
                'vpc_ReturnURL' => $this->get_return_url($order_id),
                'vpc_TicketNo' => $_SERVER["REMOTE_ADDR"]
            );
            $onepay_url = $this->url;
            $stringHashData = "";
            ksort($op_var);
            $appendAmp = 0;
            $onepay_url .= "?";

            foreach ($op_var as $key => $value) {

                if (strlen($value) > 0) {
                    if ($appendAmp == 0) {
                        $onepay_url .= urlencode($key) . '=' . urlencode($value);
                        $appendAmp = 1;
                    } else {
                        $onepay_url .= '&' . urlencode($key) . "=" . urlencode($value);
                    }
                    if ((strlen($value) > 0) && ((substr($key, 0, 4) == "vpc_") || (substr($key, 0, 5) == "user_"))) {
                        $stringHashData .= $key . "=" . $value . "&";

                    }
                }
            }
            $stringHashData = rtrim($stringHashData, "&");
            if (strlen($this->secure_secret) > 0) {
                $onepay_url .= "&vpc_SecureHash=" . strtoupper(hash_hmac('SHA256', $stringHashData, pack('H*', $this->secure_secret)));
            }

            return ['status' => true, 'redirect' => $onepay_url];

        }


        function complete_purchase($order_id)
        {
            return true;
        }

        function check_complete_purchase($order_id)
        {
            $this->setDefaultParam();
            $vpc_Txn_Secure_Hash = $_GET ["vpc_SecureHash"];
            unset ($_GET ["vpc_SecureHash"]);
            $errorExists = false;

            if (strlen($this->secure_secret) > 0 && $_GET ["vpc_TxnResponseCode"] != "7" && $_GET ["vpc_TxnResponseCode"] != "No Value Returned") {
                ksort($_GET);
                $stringHashData = "";

                foreach ($_GET as $key => $value) {
                    if ($key != "vpc_SecureHash" && (strlen($value) > 0) && ((substr($key, 0, 4) == "vpc_") || (substr($key, 0, 5) == "user_"))) {
                        $stringHashData .= $key . "=" . $value . "&";
                    }
                }
                $stringHashData = rtrim($stringHashData, "&");

                if (strtoupper($vpc_Txn_Secure_Hash) == strtoupper(hash_hmac('SHA256', $stringHashData, pack('H*', $this->secure_secret)))) {
                    $hashValidated = "CORRECT";
                } else {
                    $hashValidated = "INVALID HASH";
                }
            } else {
                $hashValidated = "INVALID HASH";
            }

            $amount = $this->null2unknown($_GET ["vpc_Amount"]);
            $orderInfo = $this->null2unknown($_GET ["vpc_OrderInfo"]);
            $txnResponseCode = $this->null2unknown($_GET ["vpc_TxnResponseCode"]);

            $tranDesc = $this->getResponseDescription($txnResponseCode);

            if ($hashValidated == "CORRECT" && $txnResponseCode == "0") {
                return ['status' => true, 'message' => $tranDesc];

            } elseif ($txnResponseCode != "0") {
                return ['status' => false, 'message' => $tranDesc];
            } elseif ($hashValidated == "INVALID HASH") {
                return ['status' => false, 'message' => $tranDesc];
            }

        }

        function getResponseDescription($responseCode)
        {

            switch ($responseCode) {
                case "0" :
                    $result = "Transaction Successful";
                    break;
                case "?" :
                    $result = "Transaction status is unknown";
                    break;
                case "1" :
                    $result = "Bank system reject";
                    break;
                case "2" :
                    $result = "Bank Declined Transaction";
                    break;
                case "3" :
                    $result = "No Reply from Bank";
                    break;
                case "4" :
                    $result = "Expired Card";
                    break;
                case "5" :
                    $result = "Insufficient funds";
                    break;
                case "6" :
                    $result = "Error Communicating with Bank";
                    break;
                case "7" :
                    $result = "Payment Server System Error";
                    break;
                case "8" :
                    $result = "Transaction Type Not Supported";
                    break;
                case "9" :
                    $result = "Bank declined transaction (Do not contact Bank)";
                    break;
                case "F" :
                    $result = "3D Secure Authentication failed";
                    break;
                case "B" :
                    $result = "Cannot authenticated by 3D-Secure Program. Please contact Issuer Bank.";
                    break;
                case "Z" :
                    $result = "Transaction was block by OFD";
                    break;
                case "99" :
                    $result = "User Cancel";
                    break;
                default  :
                    $result = "Payment fail";
            }

            return $result;

        }

        private function null2unknown($data)
        {
            if ($data == "") {
                return "No Value Returned";
            } else {
                return $data;
            }
        }

        function html()
        {
            echo Traveler_Onepay_Payment::get_inst()->loadTemplate('onepay');
        }

        function get_name()
        {
            return __('Onepay CreditCard', 'traveler-onepay');
        }

        function get_default_status()
        {
            return $this->default_status;
        }

        function is_available($item_id = false)
        {
            if (st()->get_option('pm_gway_st_onepay_enable') == 'off') {
                return false;
            } else {
                if (!st()->get_option('onepay_creditcard_merchant_id')) {
                    return false;
                }
            }

            if ($item_id) {
                $meta = get_post_meta($item_id, 'is_meta_payment_gateway_st_onepay', true);
                if ($meta == 'off') {
                    return false;
                }
            }

            return true;
        }

        function getGatewayId()
        {
            return $this->_gateway_id;
        }

        function is_check_complete_required()
        {
            return true;
        }

        function get_logo()
        {
            return Traveler_Onepay_Payment::get_inst()->pluginUrl . 'assets/img/us.png';
        }

        static function instance()
        {
            if (!self::$_ints) {
                self::$_ints = new self();
            }

            return self::$_ints;
        }

        static function add_payment($payment)
        {
            $payment['st_onepay'] = self::instance();

            return $payment;
        }
    }

    add_filter('st_payment_gateways', array('ST_Onepay_Payment_Gateway', 'add_payment'));
}