# Omnipay: Skrill

**Skrill driver for the Omnipay PHP payment processing library**

[![Build Status](https://travis-ci.org/alfaproject/omnipay-skrill.png?branch=master)](https://travis-ci.org/alfaproject/omnipay-skrill)
[![Coverage Status](https://coveralls.io/repos/alfaproject/omnipay-skrill/badge.png?branch=master)](https://coveralls.io/r/alfaproject/omnipay-skrill?branch=master)
[![Dependency Status](https://www.versioneye.com/user/projects/52c6cf75ec1375074900000f/badge.png)](https://www.versioneye.com/user/projects/52c6cf75ec1375074900000f)

[![Latest Stable Version](https://poser.pugx.org/alfaproject/omnipay-skrill/version.png)](https://packagist.org/packages/alfaproject/omnipay-skrill)
[![Total Downloads](https://poser.pugx.org/alfaproject/omnipay-skrill/d/total.png)](https://packagist.org/packages/alfaproject/omnipay-skrill)

[Omnipay](https://github.com/omnipay/omnipay) is a framework agnostic, multi-gateway payment
processing library for PHP 5.3+. This package implements Skrill support for Omnipay.

## Installation

Omnipay is installed via [Composer](http://getcomposer.org/). To install, simply add it
to your `composer.json` file:

```json
{
    "require": {
        "alfaproject/omnipay-skrill": "dev-master"
    }
}
```

And run composer to update your dependencies:

    $ curl -s http://getcomposer.org/installer | php
    $ php composer.phar update

## Basic Usage

The following gateways are provided by this package:

* Skrill

For general usage instructions, please see the main [Omnipay](https://github.com/omnipay/omnipay)
repository.

## Support

If you are having general issues with Omnipay, we suggest posting on
[Stack Overflow](http://stackoverflow.com/). Be sure to add the
[omnipay tag](http://stackoverflow.com/questions/tagged/omnipay) so it can be easily found.

If you want to keep up to date with release anouncements, discuss ideas for the project,
or ask more detailed questions, there is also a [mailing list](https://groups.google.com/forum/#!forum/omnipay) which
you can subscribe to.

If you believe you have found a bug, please report it using the [GitHub issue tracker](https://github.com/alfaproject/omnipay-skrill/issues),
or better yet, fork the library and submit a pull request.
