<?php
/**
 * Created by PhpStorm.
 * User: Dungdt
 * Date: 12/15/2015
 * Time: 3:19 PM
 */


if (!class_exists('ST_Redsys_Payment_Gateway')) {
    class ST_Redsys_Payment_Gateway extends STAbstactPaymentGateway
    {
        static private $_ints;
        private $default_status = true;
        private $_gateway_id = 'st_redsys';

        private $gateway;

        function __construct()
        {
            add_filter('st_payment_gateway_st_redsys_name', array($this, 'get_name'));

        }

        function get_option_fields()
        {
            return array(
                [
                    'id' => 'customer_redsys',
                    'label' => esc_html__('Commerce number (FUC)', 'traveler-redsys'),
                    'type' => 'text',
                    'class' => 'input-sm',
                    'desc' => esc_html__('Commerce number (FUC) provided by your bank.', 'traveler-redsys'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'terminal_redsys',
                    'label' => esc_html__('Terminal number', 'traveler-redsys'),
                    'type' => 'text',
                    'class' => 'input-sm',
                    'desc' => esc_html__('Terminal number provided by your bank.', 'traveler-redsys'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'secure_key_redsys',
                    'label' => esc_html__('Secret Key', 'traveler-redsys'),
                    'type' => 'text',
                    'class' => 'input-sm',
                    'desc' => esc_html__('Encryption secret passphrase SHA-256 provided by your bank.', 'traveler-redsys'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'test_mode_redsys',
                    'label' => esc_html__('Test Mode', 'traveler-redsys'),
                    'type' => 'on-off',
                    'std' => 'on',
                    'desc' => esc_html__('Using for Redsys sanbox account', 'traveler-redsys'),
                    'section' => 'option_pmgateway'
                ],
            );
        }

        function _pre_checkout_validate()
        {
            return true;
        }

        public function setDefaultParams()
        {
            $merchant_id = st()->get_option('customer_redsys', '');
            $terminal = st()->get_option('terminal_redsys', '');
            $secure = st()->get_option('secure_key_redsys', '');

            $this->gateway = new \Buuum\Redsys($secure);
            $this->gateway->setMerchantcode($merchant_id);
            $this->gateway->setTerminal($terminal);

            $currency_codes = array(
                'EUR' => 978,
                'USD' => 840,
                'GBP' => 826,
                'JPY' => 392,
                'ARS' => 32,
                'CAD' => 124,
                'CLP' => 152,
                'COP' => 170,
                'INR' => 356,
                'MXN' => 484,
                'PEN' => 604,
                'CHF' => 756,
                'BRL' => 986,
                'BOB' => 937,
                'TRY' => 949,
            );
            $currentCurrency = TravelHelper::get_current_currency('name');
            $currencyCode = isset($currency_codes[trim($currentCurrency)]) ? $currency_codes[trim($currentCurrency)] : 978;

            $this->gateway->setCurrency($currencyCode);
            $this->gateway->setTransactiontype('0');
            $this->gateway->setMethod('C');
        }

        public function getCartParams($order_id)
        {
            $this->setDefaultParams();
            $total = get_post_meta($order_id, 'total_price', true);

            $total = number_format($total, 2, '', '');
            $this->gateway->setAmount($total);
            $this->gateway->setOrder('ORD' . $order_id . '-' . rand(1234, 6789));
            $this->gateway->setNotification($this->get_return_url($order_id));
            $this->gateway->setUrlOk($this->get_return_url($order_id));
            $this->gateway->setUrlKo($this->get_return_url($order_id));

            $this->gateway->setTradeName(get_bloginfo('name'));
            $this->gateway->setTitular(get_post_meta($order_id, 'st_first_name', true) . ' ' . get_post_meta($order_id, 'st_last_name', true));
            $this->gateway->setProductDescription(get_the_title($order_id));
        }

        function do_checkout($order_id)
        {
            $this->setDefaultParams();
            $this->getCartParams($order_id);

            try {
                $type = 'test';
                if (st()->get_option('test_mode_redsys', 'on') == 'off') {
                    $type = 'live';
                }
                $form = $this->gateway->createForm($type);
                if (!empty($form)) {
                    return [
                        'status' => true,
                        'redirect_form' => $form
                    ];
                } else {
                    return [
                        'status' => false,
                        'message' => esc_html__('Your order has been created but we can not process', 'traveler-redsys'),
                    ];
                }
            } catch (\Exception $e) {
                return [
                    'status' => false,
                    'message' => sprintf(esc_html__('Your order has been created but we can not process. Error code: %s', 'traveler-redsys'), $e->getMessage())
                ];
            }
        }

        function package_do_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => __('This function is off', 'traveler-redsys')];
            }
            $this->setDefaultParams();
            $this->setDefaultParams();

            $order = STAdminPackages::get_inst()->get('*', $order_id);
            $total = round((float)$order->package_price, 2);
            $total = number_format($total, 2, '', '');

            $this->gateway->setAmount($total);
            $this->gateway->setOrder('Member Package' . $order_id . '-' . rand(1234, 6789));
            $this->gateway->setNotification(STAdminPackages::get_inst()->get_return_url($order_id));
            $this->gateway->setUrlOk(STAdminPackages::get_inst()->get_return_url($order_id));
            $this->gateway->setUrlKo(STAdminPackages::get_inst()->get_return_url($order_id));

            $this->gateway->setTradeName(get_bloginfo('name'));
            $this->gateway->setTitular(STInput::post('st_first_name', true) . ' ' . STInput::post('st_last_name', true));
            $this->gateway->setProductDescription(__('Member Package', 'traveler-redsys'));

            try {
                $type = 'test';
                if (st()->get_option('test_mode_redsys', 'on') == 'off') {
                    $type = 'live';
                }
                $form = $this->gateway->createForm($type);
                if (!empty($form)) {
                    return [
                        'status' => TravelHelper::st_encrypt($order_id . 'st1'),
                        'redirect_form' => $form
                    ];
                } else {
                    return [
                        'status' => TravelHelper::st_encrypt($order_id . 'st0'),
                        'message' => esc_html__('Your order has been created but we can not process', 'traveler-redsys'),
                    ];
                }
            } catch (\Exception $e) {
                return [
                    'status' => TravelHelper::st_encrypt($order_id . 'st0'),
                    'message' => sprintf(esc_html__('Your order has been created but we can not process. Error code: %s', 'traveler-redsys'), $e->getMessage())
                ];
            }
        }

        function check_complete_purchase($order_id)
        {
            $_POST = stripslashes_deep($_POST);
            $this->setDefaultParams();
            try {
                $result = $this->gateway->checkPaymentResponse($_POST);
                if ($result['error']) {
                    return [
                        'status' => false
                    ];
                } else {
                    return [
                        'status' => false
                    ];
                }
            } catch (\Exception $e) {
                return [
                    'status' => false
                ];
            }
        }

        function package_completed_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => false];
            }
            $_POST = stripslashes_deep($_POST);
            $this->setDefaultParams();
            try {
                $result = $this->gateway->checkPaymentResponse($_POST);
                if ($result['error']) {
                    return false;
                } else {
                    return true;
                }
            } catch (\Exception $e) {
                return false;
            }

        }

        function check_ipn_request_is_valid()
        {
            $usesecretsha256 = $this->secretsha256;
            if ($usesecretsha256) {
                $version = sanitize_text_field($_POST['Ds_SignatureVersion']);
                $data = sanitize_text_field($_POST['Ds_MerchantParameters']);
                $remote_sign = sanitize_text_field($_POST['Ds_Signature']);
                $miobj = new RedsysAPI();
                $localsecret = $miobj->createMerchantSignatureNotif($usesecretsha256, $data);

                if ($localsecret === $remote_sign) {
                    if ('yes' === $this->debug) {
                        $this->log->add('redsys', 'Received valid notification from Servired/RedSys');
                        $this->log->add('redsys', $data);
                    }
                    return true;
                } else {
                    if ('yes' === $this->debug) {
                        $this->log->add('redsys', 'Received INVALID notification from Servired/RedSys');
                    }
                    return false;
                }
            } else {
                if ('yes' === $this->debug) {
                    $this->log->add('redsys', 'HTTP Notification received: ' . print_r($_POST, true));
                }
                if ($_POST['Ds_MerchantCode'] === $this->customer) {
                    if ('yes' === $this->debug) {
                        $this->log->add('redsys', 'Received valid notification from Servired/RedSys');
                    }
                    return true;
                } else {
                    if ('yes' === $this->debug) {
                        $this->log->add('redsys', 'Received INVALID notification from Servired/RedSys');
                    }
                    return false;
                }
            }
        }

        function is_check_complete_required()
        {
            return true;
        }

        function html()
        {
            echo Traveler_Redsys_Payment::get_inst()->loadTemplate('redsys');
        }

        function get_name()
        {
            return __('Redsys', 'traveler-redsys');
        }

        function get_default_status()
        {
            return $this->default_status;
        }

        function is_available($item_id = false)
        {
            if (st()->get_option('pm_gway_st_redsys_enable') == 'off') {
                return false;
            } else {
                if (!st()->get_option('payu_merchant_id')) {
                    return false;
                }
                if (!st()->get_option('payu_salt_key')) {
                    return false;
                }
            }

            if ($item_id) {
                $meta = get_post_meta($item_id, 'is_meta_payment_gateway_st_redsys', true);
                if ($meta == 'off') {
                    return false;
                }
            }

            return true;
        }

        function getGatewayId()
        {
            return $this->_gateway_id;
        }

        function get_logo()
        {
            return Traveler_Redsys_Payment::get_inst()->pluginUrl . 'assets/img/redsys.png';
        }

        static function instance()
        {
            if (!self::$_ints) {
                self::$_ints = new self();
            }

            return self::$_ints;
        }

        static function add_payment($payment)
        {
            $payment['st_redsys'] = self::instance();

            return $payment;
        }
    }

    add_filter('st_payment_gateways', array('ST_Redsys_Payment_Gateway', 'add_payment'));
}