<?php
$gateway = st()->get_option('gateway_ipay88');
if (!$gateway) {
    return;
}
switch ($gateway){
    case 'MY':
        $payment_available = st()->get_option( 'paymenttype_available_ipay88' );
        break;
    case 'PH':
        $payment_available = st()->get_option( 'paymenttype_available_ph_ipay88' );
        break;
    case 'IN':
        $payment_available = st()->get_option( 'paymenttype_available_in_ipay88' );
        break;
}
if ( !$payment_available ) {
    return;
}
$payment_code = STInput::post( 'paymentcode', '' );
?>

<div class="pm-info">
        <?php
        foreach ( $payment_available as $value ) {
            if ( $gateway == 'PH' ) {
                $image_key = ST_Ipay88_Payment_Gateway::get_inst()->types_mapping_ph[ 'image' ][ $value ];
            }elseif($gateway == 'IN'){
                $image_key = ST_Ipay88_Payment_Gateway::get_inst()->types_mapping_in[ 'image' ][ $value ];
            } else {
                $image_key = ST_Ipay88_Payment_Gateway::get_inst()->types_mapping[ 'image' ][ $value ];
            }
            ?>
            <div class="form-group">
                <input class="input-radio with-gap" id="ipay88-<?php echo esc_attr( $value ); ?>-select"
                       type="radio"
                       name="paymentcode"
                       value="ipay88-<?php echo esc_attr( $value ); ?>" <?php checked( $payment_code, 'ipay88-' . esc_attr( $value ) ); ?>
                       title="<?php echo esc_attr( $gateway ); ?>">
                <label for="ipay88-<?php echo esc_attr( $value ); ?>-select">
                    <img class="img-responsive"
                         src="<?php echo esc_url( Traveler_Ipay88_Payment::get_inst()->pluginUrl . 'assets/img/' . esc_attr( $image_key ) ); ?>.png"
                         alt="<?php echo esc_html__( 'ipay88', 'traveler-ipay88' ); ?>">
                </label>
            </div>
        <?php }
        ?>
</div>