<?php
/**
 * Treweler Template
 * Functions for the templating system.
 *
 * @package  Treweler\Functions
 * @version  0.24
 */

defined( 'ABSPATH' ) || exit;

use \Symfony\Component\DomCrawler\Crawler;

if ( ! function_exists( 'twer_hex_to_rgb' ) ) {
	/**
	 * Convert HEX color to RGB(A)
	 *
	 * @param      $hex_color
	 * @param  bool  $normal
	 * @param  int  $opacity
	 *
	 * @return array|string
	 */
	function twer_hex_to_rgb( $hex_color, $normal = false, $opacity = 1 ) {
		$hex_color = $hex_color['0'] !== '#' ? '#' . $hex_color : $hex_color;
		$hex_int   = hexdec( ltrim(sanitize_hex_color( $hex_color ), '#') );
		$rgb       = array( 'red'   => 0xFF & ( $hex_int >> 0x10 ),
		                    'green' => 0xFF & ( $hex_int >> 0x8 ),
		                    'blue'  => 0xFF & $hex_int
		);
		if ( $normal ) {
			$opacity_value = is_numeric( $opacity ) ? $opacity : 1;
			$rgb           = 'rgba(' . implode( ',', array_values( $rgb ) ) . ',' . $opacity_value . ')';
		}

		return $rgb;
	}
}


if ( ! function_exists( 'twer_wp_head' ) ) {
  /**
   * Output custom wp_head in map template
   *
   * @return void
   */
  function twer_wp_head() {
    ob_start();
    do_action( 'wp_head' );
    $html = ob_get_clean();

    $crawler = new Crawler( $html);

    $selectors = [
      '[id^="treweler"]',
      '[rel^="dns-"]',
      '[id^="dashicons-"]',
      '[id^="admin-"]',
      '[id^="jquery-"]',
      'title',
      'meta',
      'style[media="print"]'
    ];

    $html_nodes = $crawler->filter(implode(', ', $selectors))->each(function (Crawler $node, $i) {
      return $node->outerHtml();
    });

    echo implode('',$html_nodes);
  }
}

if ( ! function_exists( 'twer_wp_footer' ) ) {
  /**
   * Output custom wp_footer in map template
   *
   * @return void
   */
  function twer_wp_footer() {
    ob_start();
    do_action( 'wp_footer' );
    $html = ob_get_clean();

    $crawler = new Crawler( $html);

    $selectors = [
      '[id^="treweler"]',
      '[id^="hoverintent-"]',
      '[id^="admin-"]',
      '[id^="jquery-"]',
      '#wpadminbar'
    ];

    $html_nodes = $crawler->filter(implode(', ', $selectors))->each(function (Crawler $node, $i) {
      return $node->outerHtml();
    });

    echo implode('',$html_nodes);
  }
}
