<?php
/**
 * Treweler Autoloader.
 *
 * @package Treweler/Classes
 * @version 0.24
 */

defined( 'ABSPATH' ) || exit;

/**
 * Autoloader class.
 */
class TWER_Autoloader {

	/**
	 * Path to the includes directory.
	 *
	 * @var string
	 */
	private $include_path = '';

	/**
	 * The Constructor.
	 */
	public function __construct() {
		if ( function_exists( '__autoload' ) ) {
			spl_autoload_register( '__autoload' );
		}

		spl_autoload_register( [ $this, 'autoload' ] );

		$this->include_path = untrailingslashit( plugin_dir_path( TWER_PLUGIN_FILE ) ) . '/includes/';
	}

	/**
	 * Auto-load TWER classes on demand to reduce memory consumption.
	 *
	 * @param  string  $class  Class name.
	 */
	public function autoload( $class ) {
		$class = strtolower( $class );

		if ( 0 !== strpos( $class, 'twer_' ) ) {
			return;
		}

		$file = $this->get_file_name_from_class( $class );
		$path = '';

		if ( 0 === strpos( $class, 'twer_shortcode_' ) ) {
			$path = $this->include_path . 'shortcodes/';
		} elseif ( 0 === strpos( $class, 'twer_meta_box' ) ) {
			$path = $this->include_path . 'admin/meta-boxes/';
		} elseif ( 0 === strpos( $class, 'twer_admin' ) ) {
			$path = $this->include_path . 'admin/';
		}

		if ( empty( $path ) || ! $this->load_file( $path . $file ) ) {
			$this->load_file( $this->include_path . $file );
		}
	}

	/**
	 * Take a class name and turn it into a file name.
	 *
	 * @param  string  $class  Class name.
	 *
	 * @return string
	 */
	private function get_file_name_from_class( $class ) {
		return 'class-' . str_replace( '_', '-', $class ) . '.php';
	}

	/**
	 * Include a class file.
	 *
	 * @param  string  $path  File path.
	 *
	 * @return bool Successful or not.
	 */
	private function load_file( $path ) {
		if ( $path && is_readable( $path ) ) {
			include_once $path;

			return true;
		}

		return false;
	}
}

new TWER_Autoloader();
