<?php
/**
 * Treweler Admin Functions
 *
 * @package  Treweler/Admin/Functions
 * @version  0.24
 */

if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

if ( ! function_exists( 'twer_get_screen_ids' ) ) {
  /**
   * Get all Treweler screen ids.
   *
   * @return array
   */
  function twer_get_screen_ids() {

    $twer_screen_id = sanitize_title( esc_html__( 'Treweler', 'treweler' ) );
    $screen_ids = [
      'route',
      'marker',
      'map',
      'twer-custom-fields',
      'twer-templates',
      'twer-shapes',
      'edit-map-category',
      'treweler_page_treweler-settings'
    ];

    return apply_filters( 'treweler_screen_ids', $screen_ids );
  }
}

if ( ! function_exists( 'twer_do_settings_sections' ) ) {
  /**
   * Output Treweler settings in table
   *
   * @param $page
   *
   * @return void
   */
  function twer_do_settings_sections( $page ) {
    global $wp_settings_sections, $wp_settings_fields;

    if ( ! isset( $wp_settings_sections[ $page ] ) ) {
      return;
    }

    foreach ( (array) $wp_settings_sections[ $page ] as $section ) {
      if ( $section['title'] ) {
        echo "<h2>{$section['title']}</h2>\n";
      }

      if ( $section['callback'] ) {
        call_user_func( $section['callback'], $section );
      }

      if ( ! isset( $wp_settings_fields ) || ! isset( $wp_settings_fields[ $page ] ) || ! isset( $wp_settings_fields[ $page ][ $section['id'] ] ) ) {
        continue;
      }
      echo '<table class="form-table table twer-table twer-table--cells-2" role="presentation">';
      do_settings_fields( $page, $section['id'] );
      echo '</table>';
    }
  }
}
