/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
var __webpack_exports__ = {};
/*!************************************************!*\
  !*** ./src/js/admin/treweler-custom-fields.js ***!
  \************************************************/


const {
  __
} = wp.i18n;

class TWER_CUSTOM_FIELDS {
  toggleRowByValue($rows, value, event) {
    switch (value) {
      case 'link':
        $rows.forEach((row, index) => {
          if (['custom_field_text', 'custom_field_email', 'custom_field_phone', 'custom_field_separator'].includes(row.dataset.rowId)) {
            row.classList.add('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.setAttribute('disabled', ''));
          } else if ('custom_field_link' === row.dataset.rowId) {
            row.classList.remove('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.removeAttribute('disabled'));

            if (event === 'change') {
              Array.from(row.querySelectorAll('input:not([type="checkbox"]):not([type="hidden"])')).forEach(function (e) {
                e.value = '';
              });
            }
          }
        });
        break;

      case 'text':
        $rows.forEach((row, index) => {
          if (['custom_field_link', 'custom_field_email', 'custom_field_phone', 'custom_field_separator'].includes(row.dataset.rowId)) {
            row.classList.add('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.setAttribute('disabled', ''));
          } else if ('custom_field_text' === row.dataset.rowId) {
            row.classList.remove('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.removeAttribute('disabled'));

            if (event === 'change') {
              Array.from(row.querySelectorAll('input:not([type="checkbox"]):not([type="hidden"])')).forEach(function (e) {
                e.value = '';
              });
            }
          }
        });
        break;

      case 'email':
        $rows.forEach((row, index) => {
          if (['custom_field_link', 'custom_field_text', 'custom_field_phone', 'custom_field_separator'].includes(row.dataset.rowId)) {
            row.classList.add('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.setAttribute('disabled', ''));
          } else if ('custom_field_email' === row.dataset.rowId) {
            row.classList.remove('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.removeAttribute('disabled'));

            if (event === 'change') {
              Array.from(row.querySelectorAll('input:not([type="checkbox"]):not([type="hidden"])')).forEach(function (e) {
                e.value = '';
              });
            }
          }
        });
        break;

      case 'phone':
        $rows.forEach((row, index) => {
          if (['custom_field_link', 'custom_field_text', 'custom_field_email', 'custom_field_separator'].includes(row.dataset.rowId)) {
            row.classList.add('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.setAttribute('disabled', ''));
          } else if ('custom_field_phone' === row.dataset.rowId) {
            row.classList.remove('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.removeAttribute('disabled'));

            if (event === 'change') {
              Array.from(row.querySelectorAll('input:not([type="checkbox"]):not([type="hidden"])')).forEach(function (e) {
                e.value = '';
              });
            }
          }
        });
        break;

      case 'separator':
        $rows.forEach((row, index) => {
          if (['custom_field_link', 'custom_field_text', 'custom_field_email', 'custom_field_phone'].includes(row.dataset.rowId)) {
            row.classList.add('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.setAttribute('disabled', ''));
          } else if ('custom_field_separator' === row.dataset.rowId) {
            row.classList.remove('d-none');
            Array.from(row.querySelectorAll('input')).forEach(e => e.removeAttribute('disabled'));

            if (event === 'change') {
              Array.from(row.querySelectorAll('input:not([type="checkbox"]):not([type="hidden"])')).forEach(function (e) {
                e.value = '';
              });
            }
          }
        });
        break;
    }

    if ('separator' === value) {
      $rows.forEach((row, index) => {
        if ('custom_field_show' === row.dataset.rowId) {
          row.classList.add('d-none');
        }
      });
    } else {
      $rows.forEach((row, index) => {
        if ('custom_field_show' === row.dataset.rowId) {
          row.classList.remove('d-none');
        }
      });
    }
  }

  toggleRowHandlers() {
    const $fieldTypes = document.querySelectorAll('select.js-custom-fields-type');
    const $fieldRows = document.querySelectorAll('.js-twer-row');

    if ($fieldTypes.length > 0 && $fieldRows.length > 0) {
      $fieldTypes.forEach((select, index) => {
        this.toggleRowByValue($fieldRows, select.value, 'load');
        select.addEventListener('change', e => {
          this.toggleRowByValue($fieldRows, e.target.value, 'change');
        });
      });
    }
  }

  constructor(props) {
    // Init JQuery
    this.$ = $ = props;
    this.toggleRowHandlers();
  }

} //;(function(){


window.addEventListener('DOMContentLoaded', () => {
  new TWER_CUSTOM_FIELDS();
}); //})();
/******/ })()
;
//# sourceMappingURL=treweler-custom-fields.js.map