<?php

namespace Noodlehaus\Test\Parser;

use Noodlehaus\Parser\Php;
use PHPUnit\Framework\TestCase;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-04-21 at 22:37:22.
 */
class PhpTest extends TestCase
{
    /**
     * @var Php
     */
    protected $php;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->php = new Php();
    }

    /**
     * @covers \Noodlehaus\Parser\Php::getSupportedExtensions()
     */
    public function testGetSupportedExtensions()
    {
        $expected = ['php'];
        $actual   = $this->php->getSupportedExtensions();
        $this->assertSame($expected, $actual);
    }

    /**
     * @covers \Noodlehaus\Parser\Php::parseFile()
     * @covers \Noodlehaus\Parser\Php::parse()
     */
    public function testLoadInvalidPhp()
    {
        $this->expectException(\Noodlehaus\Exception\UnsupportedFormatException::class);
        $this->expectExceptionMessage('PHP data does not return an array');
        $this->php->parseFile(__DIR__ . '/../mocks/fail/error.php');
    }

    /**
     * @covers \Noodlehaus\Parser\Php::parseFile()
     */
    public function testLoadExceptionalPhpFile()
    {
        $this->expectException(\Noodlehaus\Exception\ParseException::class);
        $this->expectExceptionMessage('PHP file threw an exception');
        $this->php->parseFile(__DIR__ . '/../mocks/fail/error-exception.php');
    }

    /**
     * @covers \Noodlehaus\Parser\Php::parseString()
     * @covers \Noodlehaus\Parser\Php::isolate()
     */
    public function testLoadExceptionalPhpString()
    {
        $this->expectException(\Noodlehaus\Exception\ParseException::class);
        $this->expectExceptionMessage('PHP string threw an exception');
        $this->php->parseString(file_get_contents(__DIR__ . '/../mocks/fail/error-exception.php'));
    }

    /**
     * @covers \Noodlehaus\Parser\Php::parseFile()
     * @covers \Noodlehaus\Parser\Php::parseString()
     * @covers \Noodlehaus\Parser\Php::isolate()
     * @covers \Noodlehaus\Parser\Php::parse()
     */
    public function testLoadPhpArray()
    {
        $file = $this->php->parseFile(__DIR__ . '/../mocks/pass/config.php');
        $string = $this->php->parseString(file_get_contents(__DIR__ . '/../mocks/pass/config.php'));

        $this->assertSame('localhost', $file['host']);
        $this->assertSame(80, $file['port']);

        $this->assertSame('localhost', $string['host']);
        $this->assertSame(80, $string['port']);
    }

    /**
     * @covers \Noodlehaus\Parser\Php::parseFile()
     * @covers \Noodlehaus\Parser\Php::parseString()
     * @covers \Noodlehaus\Parser\Php::isolate()
     * @covers \Noodlehaus\Parser\Php::parse()
     */
    public function testLoadPhpCallable()
    {
        $file = $this->php->parseFile(__DIR__ . '/../mocks/pass/config-exec.php');
        $string = $this->php->parseString(file_get_contents(__DIR__ . '/../mocks/pass/config-exec.php'));

        $this->assertSame('localhost', $file['host']);
        $this->assertSame(80, $file['port']);

        $this->assertSame('localhost', $string['host']);
        $this->assertSame(80, $string['port']);
    }

    /**
     * @covers \Noodlehaus\Parser\Php::parseFile()
     * @covers \Noodlehaus\Parser\Php::parseString()
     * @covers \Noodlehaus\Parser\Php::isolate()
     * @covers \Noodlehaus\Parser\Php::parse()
     */
    public function testLoadPhpVariable()
    {
        $file = $this->php->parseFile(__DIR__ . '/../mocks/pass/config-var.php');
        $string = $this->php->parseString(file_get_contents(__DIR__ . '/../mocks/pass/config-var.php'));

        $this->assertSame('localhost', $file['host']);
        $this->assertSame(80, $file['port']);

        $this->assertSame('localhost', $string['host']);
        $this->assertSame(80, $string['port']);
    }
}
