<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveMaps\Plugin;

/**
 * Defines the list of available maps
 */
class MapList {

	public $maps;

	public function __construct() {
		$this->add_filters();
		$this->set_maps();
	}

	public function add_filters() {

		add_filter(
			'igm_map_list_json',
			function( $json ) {
				$converted = json_decode( $json, true );

				// to add this to the end of the list
				$options = $converted;

				$options[ __( 'Portugal Maps' ) ] = [
					'custom_cmoreira_portugalLisboaFreguesias'     => 'Portugal - Freguesias Lisboa (23kb)',
					'custom_cmoreira_portugalPortoFreguesias'      => 'Portugal - Freguesias Porto (12kb)',
					'custom_cmoreira_portugalModifiedDistricts'    => 'Portugal - Districts Viewport (73kb)',
					'custom_cmoreira_portugalModifiedMunicipios'   => 'Portugal -  Municipios Viewport - Incomplete (369kb)',
					'custom_cmoreira_portugalModifiedConcelhos'    => 'Portugal -  Concelhos Viewport (576kb)',
					'custom_cmoreira_portugalModifiedConcelhosLow' => 'Portugal -  Concelhos Viewport Low (323kb)',
				];

				return json_encode( $options );
			}
		);

	}

	public function set_maps() {
		$json = '{
			"World, Regions & Continents": {
				"region\/world\/africaHigh": "Africa High (79kb)",
				"region\/world\/africaLow": "Africa Low (37kb)",
				"region\/world\/africaMoroccoHigh": "Africa Morocco High (78kb)",
				"region\/world\/africaMoroccoLow": "Africa Morocco Low (36kb)",
				"region\/world\/africaMoroccoUltra": "Africa Morocco Ultra (184kb)",
				"region\/world\/africaUltra": "Africa Ultra (185kb)",
				"region\/world\/asiaHigh": "Asia High (161kb)",
				"region\/world\/asiaIndiaHigh": "Asia India High (162kb)",
				"region\/world\/asiaIndiaLow": "Asia India Low (63kb)",
				"region\/world\/asiaIndiaUltra": "Asia India Ultra (407kb)",
				"region\/world\/asiaLow": "Asia Low (63kb)",
				"region\/world\/asiaUltra": "Asia Ultra (403kb)",
				"region\/world\/caribbeanHigh": "Caribbean High (13kb)",
				"region\/world\/caribbeanLow": "Caribbean Low (9kb)",
				"region\/world\/caribbeanUltra": "Caribbean Ultra (24kb)",
				"region\/world\/centralAmericaHigh": "Central America High (13kb)",
				"region\/world\/centralAmericaLow": "Central America Low (5kb)",
				"region\/world\/europeHigh": "Europe High (106kb)",
				"region\/world\/europeLow": "Europe Low (45kb)",
				"region\/world\/europeUltra": "Europe Ultra (253kb)",
				"region\/world\/latinAmericaHigh": "Latin America High (78kb)",
				"region\/world\/latinAmericaLow": "Latin America Low (34kb)",
				"region\/world\/latinAmericaUltra": "Latin America Ultra (185kb)",
				"region\/world\/middleEastHigh": "Middle East High (16kb)",
				"region\/world\/middleEastLow": "Middle East Low (7kb)",
				"region\/world\/middleEastUltra": "Middle East Ultra (36kb)",
				"region\/world\/northAmericaHigh": "North America High (141kb)",
				"region\/world\/northAmericaLow": "North America Low (55kb)",
				"region\/world\/northAmericaUltra": "North America Ultra (351kb)",
				"region\/world\/oceaniaHigh": "Oceania High (52kb)",
				"region\/world\/oceaniaLow": "Oceania Low (20kb)",
				"region\/world\/oceaniaUltra": "Oceania Ultra (128kb)",
				"region\/world\/southAmericaHigh": "South America High (51kb)",
				"region\/world\/southAmericaLow": "South America Low (20kb)",
				"region\/world\/southAmericaUltra": "South America Ultra (130kb)",
				"region\/world\/worldRegionsHigh": "World Regions High (357kb)",
				"region\/world\/worldRegionsLow": "World Regions Low (121kb)",
				"region\/world\/worldRegionsUltra": "World Regions Ultra (935kb)",
				"continentsHigh": "Continents High (351kb)",
				"continentsLow": "Continents Low (118kb)",
				"continentsRussiaAsiaHigh": "Continents Russia Asia High (355kb)",
				"continentsRussiaAsiaLow": "Continents Russia Asia Low (120kb)",
				"continentsRussiaAsiaUltra": "Continents Russia Asia Ultra (931kb)",
				"continentsRussiaEuropeHigh": "Continents Russia Europe High (363kb)",
				"continentsRussiaEuropeLow": "Continents Russia Europe Low (123kb)",
				"continentsRussiaEuropeUltra": "Continents Russia Europe Ultra (952kb)",
				"continentsUltra": "Continents Ultra (924kb)",
				"unRegionsHigh": "UN Regions High (380kb)",
				"unRegionsLow": "UN Regions Low (133kb)",
				"worldChinaHigh": "World China High (608kb)",
				"worldChinaLow": "World China Low (246kb)",
				"worldChinaUltra": "World China Ultra (1mb)",
				"worldGreatLakesHigh": "World Great Lakes High (610kb)",
				"worldGreatLakesLow": "World Great Lakes Low (247kb)",
				"worldGreatLakesUltra": "World Great Lakes Ultra (1mb)",
				"worldHigh": "World High (603kb)",
				"worldIndiaHigh": "World India High (604kb)",
				"worldIndiaLow": "World India Low (245kb)",
				"worldIndiaUltra": "World India Ultra (1mb)",
				"worldLow": "World Low (244kb)",
				"worldMoroccoHigh": "World Morocco High (610kb)",
				"worldMoroccoLow": "World Morocco Low (247kb)",
				"worldMoroccoUltra": "World Morocco Ultra (1mb)",
				"worldOutlineHigh": "World Outline High (314kb)",
				"worldOutlineLow": "World Outline Low (105kb)",
				"worldOutlineUltra": "World Outline Ultra (828kb)",
				"worldRussiaHigh": "World Russia High (610kb)",
				"worldRussiaLow": "World Russia Low (247kb)",
				"worldRussiaUltra": "World Russia Ultra (1mb)",
				"worldTimeZoneAreasHigh": "World Time Zone Areas High (482kb)",
				"worldTimeZoneAreasLow": "World Time Zone Areas Low (179kb)",
				"worldTimeZoneAreasUltra": "World Time Zone Areas Ultra (1mb)",
				"worldTimeZonesHigh": "World Time Zones High (876kb)",
				"worldTimeZonesLow": "World Time Zones Low (337kb)",
				"worldTimeZonesUltra": "World Time Zones Ultra (2mb)",
				"worldUltra": "World Ultra (1mb)"
			},
			"Countries": {
				"afghanistanHigh": "Afghanistan High (142kb)",
				"afghanistanLow": "Afghanistan Low (59kb)",
				"albaniaHigh": "Albania High (37kb)",
				"albaniaLow": "Albania Low (16kb)",
				"algeriaHigh": "Algeria High (127kb)",
				"algeriaLow": "Algeria Low (55kb)",
				"americanSamoaHigh": "American Samoa High (44kb)",
				"americanSamoaLow": "American Samoa Low (17kb)",
				"andorraHigh": "Andorra High (19kb)",
				"andorraLow": "Andorra Low (8kb)",
				"angolaHigh": "Angola High (69kb)",
				"angolaLow": "Angola Low (30kb)",
				"anguillaHigh": "Anguilla High (51kb)",
				"anguillaLow": "Anguilla Low (24kb)",
				"antiguaBarbudaHigh": "Antigua Barbuda High (39kb)",
				"antiguaBarbudaLow": "Antigua Barbuda Low (17kb)",
				"argentinaHigh": "Argentina High (77kb)",
				"argentinaLow": "Argentina Low (33kb)",
				"armeniaHigh": "Armenia High (24kb)",
				"armeniaLow": "Armenia Low (11kb)",
				"arubaHigh": "Aruba High (11kb)",
				"arubaLow": "Aruba Low (4kb)",
				"australiaHigh": "Australia High (43kb)",
				"australiaLow": "Australia Low (18kb)",
				"austriaHigh": "Austria High (181kb)",
				"austriaLow": "Austria Low (70kb)",
				"azerbaijanHigh": "Azerbaijan High (178kb)",
				"azerbaijanLow": "Azerbaijan Low (79kb)",
				"bahamasHigh": "Bahamas High (38kb)",
				"bahamasLow": "Bahamas Low (19kb)",
				"bahrainHigh": "Bahrain High (34kb)",
				"bahrainLow": "Bahrain Low (14kb)",
				"bangladeshHigh": "Bangladesh High (60kb)",
				"bangladeshLow": "Bangladesh Low (25kb)",
				"barbadosHigh": "Barbados High (18kb)",
				"barbadosLow": "Barbados Low (9kb)",
				"belarusHigh": "Belarus High (55kb)",
				"belarusLow": "Belarus Low (21kb)",
				"belgiumHigh": "Belgium High (151kb)",
				"belgiumLow": "Belgium Low (58kb)",
				"belizeHigh": "Belize High (61kb)",
				"belizeLow": "Belize Low (24kb)",
				"beninHigh": "Benin High (78kb)",
				"beninLow": "Benin Low (31kb)",
				"bermudaHigh": "Bermuda High (39kb)",
				"bermudaLow": "Bermuda Low (17kb)",
				"bhutanHigh": "Bhutan High (50kb)",
				"bhutanLow": "Bhutan Low (22kb)",
				"boliviaHigh": "Bolivia High (20kb)",
				"boliviaLow": "Bolivia Low (9kb)",
				"bonaireSintEustatiusSabaHigh": "Bonaire Sint Eustatius Saba High (5kb)",
				"bonaireSintEustatiusSabaLow": "Bonaire Sint Eustatius Saba Low (2kb)",
				"bosniaHerzegovinaCantonsHigh": "Bosnia Herzegovina Cantons High (27kb)",
				"bosniaHerzegovinaCantonsLow": "Bosnia Herzegovina Cantons Low (13kb)",
				"bosniaHerzegovinaHigh": "Bosnia Herzegovina High (17kb)",
				"bosniaHerzegovinaLow": "Bosnia Herzegovina Low (7kb)",
				"botswanaHigh": "Botswana High (54kb)",
				"botswanaLow": "Botswana Low (21kb)",
				"brazilHigh": "Brazil High (93kb)",
				"brazilLow": "Brazil Low (40kb)",
				"britishIndianOceanTerritoryHigh": "British Indian Ocean Territory High (166kb)",
				"britishIndianOceanTerritoryLow": "British Indian Ocean Territory Low (70kb)",
				"britishVirginIslandsHigh": "British Virgin Islands High (102kb)",
				"britishVirginIslandsLow": "British Virgin Islands Low (39kb)",
				"bruneiDarussalamHigh": "Brunei Darussalam High (17kb)",
				"bruneiDarussalamLow": "Brunei Darussalam Low (7kb)",
				"bulgariaHigh": "Bulgaria High (88kb)",
				"bulgariaLow": "Bulgaria Low (38kb)",
				"burkinaFasoHigh": "Burkina Faso High (33kb)",
				"burkinaFasoLow": "Burkina Faso Low (15kb)",
				"burundiHigh": "Burundi High (73kb)",
				"burundiLow": "Burundi Low (31kb)",
				"cambodiaHigh": "Cambodia High (2mb)",
				"cambodiaLow": "Cambodia Low (688kb)",
				"cameroonHigh": "Cameroon High (59kb)",
				"cameroonLow": "Cameroon Low (27kb)",
				"canadaHigh": "Canada High (223kb)",
				"canadaLow": "Canada Low (89kb)",
				"capeVerdeHigh": "Cape Verde High (41kb)",
				"capeVerdeLow": "Cape Verde Low (20kb)",
				"caymanIslandsHigh": "Cayman Islands High (17kb)",
				"caymanIslandsLow": "Cayman Islands Low (7kb)",
				"centralAfricanRepublicHigh": "Central African Republic High (53kb)",
				"centralAfricanRepublicLow": "Central African Republic Low (23kb)",
				"chadHigh": "Chad High (28kb)",
				"chadLow": "Chad Low (14kb)",
				"channelIslandsHigh": "Channel Islands High (38kb)",
				"channelIslandsLow": "Channel Islands Low (27kb)",
				"chileHigh": "Chile High (297kb)",
				"chileLow": "Chile Low (122kb)",
				"chinaHigh": "China High (201kb)",
				"chinaLow": "China Low (81kb)",
				"cocosKeelingHigh": "Cocos Keeling High (31kb)",
				"cocosKeelingLow": "Cocos Keeling Low (12kb)",
				"colombiaHigh": "Colombia High (73kb)",
				"colombiaLow": "Colombia Low (33kb)",
				"colombiaMuniHigh": "Colombia Muni High (2mb)",
				"colombiaMuniLow": "Colombia Muni Low (922kb)",
				"comorosHigh": "Comoros High (20kb)",
				"comorosLow": "Comoros Low (8kb)",
				"congoDRHigh": "Congo D R High (90kb)",
				"congoDRLow": "Congo D R Low (39kb)",
				"congoHigh": "Congo High (57kb)",
				"congoLow": "Congo Low (23kb)",
				"costaRicaHigh": "Costa Rica High (48kb)",
				"costaRicaLow": "Costa Rica Low (21kb)",
				"cotedIvoireHigh": "Coted Ivoire High (259kb)",
				"cotedIvoireLow": "Coted Ivoire Low (96kb)",
				"croatiaHigh": "Croatia High (61kb)",
				"croatiaLow": "Croatia Low (27kb)",
				"cubaHigh": "Cuba High (80kb)",
				"cubaLow": "Cuba Low (34kb)",
				"curacaoHigh": "Curacao High (34kb)",
				"curacaoLow": "Curacao Low (13kb)",
				"cyprusHigh": "Cyprus High (30kb)",
				"cyprusLow": "Cyprus Low (12kb)",
				"cyprusNorthCyprusHigh": "Cyprus North Cyprus High (43kb)",
				"cyprusNorthCyprusLow": "Cyprus North Cyprus Low (19kb)",
				"czechRepublicHigh": "Czech Republic High (301kb)",
				"czechRepublicLow": "Czech Republic Low (112kb)",
				"czechiaHigh": "Czechia High (301kb)",
				"czechiaLow": "Czechia Low (112kb)",
				"denmarkHigh": "Denmark High (73kb)",
				"denmarkLow": "Denmark Low (29kb)",
				"djiboutiHigh": "Djibouti High (13kb)",
				"djiboutiLow": "Djibouti Low (6kb)",
				"dominicaHigh": "Dominica High (76kb)",
				"dominicaLow": "Dominica Low (33kb)",
				"dominicanRepublicHigh": "Dominican Republic High (76kb)",
				"dominicanRepublicLow": "Dominican Republic Low (35kb)",
				"dominicanRepublicMuniHigh": "Dominican Republic Muni High (940kb)",
				"dominicanRepublicMuniLow": "Dominican Republic Muni Low (289kb)",
				"ecuadorHigh": "Ecuador High (93kb)",
				"ecuadorLow": "Ecuador Low (39kb)",
				"egyptHigh": "Egypt High (108kb)",
				"egyptLow": "Egypt Low (53kb)",
				"elSalvadorHigh": "EL Salvador High (59kb)",
				"elSalvadorLow": "EL Salvador Low (26kb)",
				"equatorialGuineaHigh": "Equatorial Guinea High (797kb)",
				"equatorialGuineaLow": "Equatorial Guinea Low (287kb)",
				"eritreaHigh": "Eritrea High (21kb)",
				"eritreaLow": "Eritrea Low (9kb)",
				"estoniaHigh": "Estonia High (96kb)",
				"estoniaLow": "Estonia Low (40kb)",
				"eswatiniHigh": "Eswatini High (40kb)",
				"eswatiniLow": "Eswatini Low (18kb)",
				"ethiopiaHigh": "Ethiopia High (59kb)",
				"ethiopiaLow": "Ethiopia Low (24kb)",
				"falklandIslandsHigh": "Falkland Islands High (239kb)",
				"falklandIslandsLow": "Falkland Islands Low (92kb)",
				"faroeIslandsHigh": "Faroe Islands High (21kb)",
				"faroeIslandsLow": "Faroe Islands Low (9kb)",
				"fijiEastHigh": "Fiji East High (5kb)",
				"fijiEastLow": "Fiji East Low (2kb)",
				"fijiWestHigh": "Fiji West High (24kb)",
				"fijiWestLow": "Fiji West Low (10kb)",
				"finlandHigh": "Finland High (169kb)",
				"finlandLow": "Finland Low (74kb)",
				"franceDepartments2High": "France Departments2 High (191kb)",
				"franceDepartments2Low": "France Departments2 Low (90kb)",
				"franceDepartmentsHigh": "France Departments High (158kb)",
				"franceDepartmentsLow": "France Departments Low (76kb)",
				"franceHigh": "France High (55kb)",
				"franceLow": "France Low (22kb)",
				"frenchGuianaHigh": "French Guiana High (28kb)",
				"frenchGuianaLow": "French Guiana Low (11kb)",
				"frenchPolynesiaHigh": "French Polynesia High (847kb)",
				"frenchPolynesiaLow": "French Polynesia Low (178kb)",
				"gabonHigh": "Gabon High (212kb)",
				"gabonLow": "Gabon Low (91kb)",
				"gambiaHigh": "Gambia High (22kb)",
				"gambiaLow": "Gambia Low (10kb)",
				"georgiaHigh": "Georgia High (72kb)",
				"georgiaLow": "Georgia Low (29kb)",
				"georgiaSouthOssetiaHigh": "Georgia South Ossetia High (74kb)",
				"georgiaSouthOssetiaLow": "Georgia South Ossetia Low (31kb)",
				"germanyHigh": "Germany High (665kb)",
				"germanyLow": "Germany Low (253kb)",
				"ghanaHigh": "Ghana High (53kb)",
				"ghanaLow": "Ghana Low (22kb)",
				"greeceHigh": "Greece High (106kb)",
				"greeceLow": "Greece Low (44kb)",
				"greenlandHigh": "Greenland High (166kb)",
				"greenlandLow": "Greenland Low (66kb)",
				"grenadaHigh": "Grenada High (93kb)",
				"grenadaLow": "Grenada Low (37kb)",
				"guadeloupeHigh": "Guadeloupe High (548kb)",
				"guadeloupeLow": "Guadeloupe Low (235kb)",
				"guamHigh": "Guam High (334kb)",
				"guamLow": "Guam Low (161kb)",
				"guatemalaHigh": "Guatemala High (343kb)",
				"guatemalaLow": "Guatemala Low (167kb)",
				"guineaBissauHigh": "Guinea Bissau High (35kb)",
				"guineaBissauLow": "Guinea Bissau Low (15kb)",
				"guineaHigh": "Guinea High (43kb)",
				"guineaLow": "Guinea Low (17kb)",
				"guyanaHigh": "Guyana High (36kb)",
				"guyanaLow": "Guyana Low (15kb)",
				"haitiHigh": "Haiti High (19kb)",
				"haitiLow": "Haiti Low (9kb)",
				"hondurasHigh": "Honduras High (79kb)",
				"hondurasLow": "Honduras Low (33kb)",
				"hongKongHigh": "Hong Kong High (75kb)",
				"hongKongLow": "Hong Kong Low (33kb)",
				"hungaryHigh": "Hungary High (54kb)",
				"hungaryLow": "Hungary Low (24kb)",
				"icelandHigh": "Iceland High (73kb)",
				"icelandLow": "Iceland Low (33kb)",
				"india2019High": "India2019 High (173kb)",
				"india2019Low": "India2019 Low (70kb)",
				"india2020High": "India2020 High (177kb)",
				"india2020Low": "India2020 Low (71kb)",
				"indiaHigh": "India High (170kb)",
				"indiaLow": "India Low (69kb)",
				"indonesiaHigh": "Indonesia High (167kb)",
				"indonesiaLow": "Indonesia Low (71kb)",
				"iranHigh": "Iran High (108kb)",
				"iranLow": "Iran Low (49kb)",
				"iraqHigh": "Iraq High (124kb)",
				"iraqLow": "Iraq Low (56kb)",
				"irelandHigh": "Ireland High (222kb)",
				"irelandLow": "Ireland Low (93kb)",
				"irelandProvincesHigh": "Ireland Provinces High (136kb)",
				"irelandProvincesLow": "Ireland Provinces Low (54kb)",
				"israelHigh": "Israel High (27kb)",
				"israelLow": "Israel Low (12kb)",
				"israelPalestineHigh": "Israel Palestine High (49kb)",
				"israelPalestineLow": "Israel Palestine Low (23kb)",
				"italyHigh": "Italy High (66kb)",
				"italyLow": "Italy Low (28kb)",
				"italyProvincesHigh": "Italy Provinces High (279kb)",
				"italyProvincesLow": "Italy Provinces Low (124kb)",
				"jamaicaHigh": "Jamaica High (15kb)",
				"jamaicaLow": "Jamaica Low (8kb)",
				"japanHigh": "Japan High (181kb)",
				"japanLow": "Japan Low (78kb)",
				"jordanHigh": "Jordan High (23kb)",
				"jordanLow": "Jordan Low (11kb)",
				"kazakhstanHigh": "Kazakhstan High (90kb)",
				"kazakhstanLow": "Kazakhstan Low (40kb)",
				"kenyaHigh": "Kenya High (4mb)",
				"kenyaLow": "Kenya Low (1mb)",
				"kosovoHigh": "Kosovo High (25kb)",
				"kosovoLow": "Kosovo Low (10kb)",
				"kuwaitHigh": "Kuwait High (13kb)",
				"kuwaitLow": "Kuwait Low (6kb)",
				"kyrgyzstanHigh": "Kyrgyzstan High (133kb)",
				"kyrgyzstanLow": "Kyrgyzstan Low (50kb)",
				"laosHigh": "Laos High (59kb)",
				"laosLow": "Laos Low (26kb)",
				"latvia2021High": "Latvia2021 High (95kb)",
				"latvia2021Low": "Latvia2021 Low (43kb)",
				"latviaHigh": "Latvia High (164kb)",
				"latviaLow": "Latvia Low (82kb)",
				"lebanonHigh": "Lebanon High (562kb)",
				"lebanonLow": "Lebanon Low (215kb)",
				"lesothoHigh": "Lesotho High (582kb)",
				"lesothoLow": "Lesotho Low (262kb)",
				"liberiaHigh": "Liberia High (46kb)",
				"liberiaLow": "Liberia Low (19kb)",
				"libyaHigh": "Libya High (31kb)",
				"libyaLow": "Libya Low (16kb)",
				"liechtensteinHigh": "Liechtenstein High (29kb)",
				"liechtensteinLow": "Liechtenstein Low (14kb)",
				"lithuaniaHigh": "Lithuania High (154kb)",
				"lithuaniaLow": "Lithuania Low (61kb)",
				"luxembourgHigh": "Luxembourg High (52kb)",
				"luxembourgLow": "Luxembourg Low (21kb)",
				"madagascarProvinceHigh": "Madagascar Province High (85kb)",
				"madagascarProvinceLow": "Madagascar Province Low (32kb)",
				"madagascarRegionHigh": "Madagascar Region High (99kb)",
				"madagascarRegionLow": "Madagascar Region Low (42kb)",
				"malawiHigh": "Malawi High (1mb)",
				"malawiLow": "Malawi Low (459kb)",
				"malaysiaHigh": "Malaysia High (86kb)",
				"malaysiaLow": "Malaysia Low (36kb)",
				"maldivesHigh": "Maldives High (62kb)",
				"maldivesIslandsHigh": "Maldives Islands High (499kb)",
				"maldivesIslandsLow": "Maldives Islands Low (226kb)",
				"maldivesLow": "Maldives Low (26kb)",
				"maliHigh": "Mali High (279kb)",
				"maliLow": "Mali Low (103kb)",
				"maltaHigh": "Malta High (15kb)",
				"maltaLow": "Malta Low (7kb)",
				"martiniqueHigh": "Martinique High (290kb)",
				"martiniqueLow": "Martinique Low (115kb)",
				"mauritaniaHigh": "Mauritania High (94kb)",
				"mauritaniaLow": "Mauritania Low (39kb)",
				"mauritiusHigh": "Mauritius High (389kb)",
				"mauritiusLow": "Mauritius Low (136kb)",
				"mexicoHigh": "Mexico High (180kb)",
				"mexicoLow": "Mexico Low (76kb)",
				"moldovaHigh": "Moldova High (45kb)",
				"moldovaLow": "Moldova Low (24kb)",
				"mongoliaHigh": "Mongolia High (160kb)",
				"mongoliaLow": "Mongolia Low (71kb)",
				"montenegroHigh": "Montenegro High (67kb)",
				"montenegroLow": "Montenegro Low (29kb)",
				"montserratHigh": "Montserrat High (6kb)",
				"montserratLow": "Montserrat Low (3kb)",
				"moroccoHigh": "Morocco High (196kb)",
				"moroccoLow": "Morocco Low (87kb)",
				"mozambiqueHigh": "Mozambique High (85kb)",
				"mozambiqueLow": "Mozambique Low (34kb)",
				"myanmarHigh": "Myanmar High (142kb)",
				"myanmarLow": "Myanmar Low (57kb)",
				"namibiaHigh": "Namibia High (53kb)",
				"namibiaLow": "Namibia Low (24kb)",
				"nepalHigh": "Nepal High (34kb)",
				"nepalLow": "Nepal Low (14kb)",
				"netherlandsHigh": "Netherlands High (120kb)",
				"netherlandsLow": "Netherlands Low (49kb)",
				"newZealandHigh": "New Zealand High (176kb)",
				"newZealandLow": "New Zealand Low (71kb)",
				"nicaraguaHigh": "Nicaragua High (79kb)",
				"nicaraguaLow": "Nicaragua Low (35kb)",
				"nigerHigh": "Niger High (28kb)",
				"nigerLow": "Niger Low (12kb)",
				"nigeriaHigh": "Nigeria High (85kb)",
				"nigeriaLow": "Nigeria Low (39kb)",
				"northKoreaHigh": "North Korea High (170kb)",
				"northKoreaLow": "North Korea Low (74kb)",
				"northMacedoniaHigh": "North Macedonia High (104kb)",
				"northMacedoniaLow": "North Macedonia Low (50kb)",
				"northernMarianaHigh": "Northern Mariana High (224kb)",
				"northernMarianaLow": "Northern Mariana Low (91kb)",
				"norway2020High": "Norway2020 High (295kb)",
				"norway2020Low": "Norway2020 Low (120kb)",
				"norwayHigh": "Norway High (301kb)",
				"norwayLow": "Norway Low (125kb)",
				"omanHigh": "Oman High (74kb)",
				"omanLow": "Oman Low (33kb)",
				"pakistanHigh": "Pakistan High (39kb)",
				"pakistanLow": "Pakistan Low (16kb)",
				"palestineHigh": "Palestine High (37kb)",
				"palestineLow": "Palestine Low (17kb)",
				"panamaHigh": "Panama High (53kb)",
				"panamaLow": "Panama Low (23kb)",
				"paraguayHigh": "Paraguay High (547kb)",
				"paraguayLow": "Paraguay Low (189kb)",
				"peruHigh": "Peru High (69kb)",
				"peruLow": "Peru Low (31kb)",
				"philippinesHigh": "Philippines High (117kb)",
				"philippinesLow": "Philippines Low (58kb)",
				"polandHigh": "Poland High (411kb)",
				"polandLow": "Poland Low (161kb)",
				"portugalHigh": "Portugal High (44kb)",
				"portugalLow": "Portugal Low (20kb)",
				"portugalRegionsHigh": "Portugal Regions High (29kb)",
				"portugalRegionsLow": "Portugal Regions Low (12kb)",
				"puertoRicoHigh": "Puerto Rico High (480kb)",
				"puertoRicoLow": "Puerto Rico Low (223kb)",
				"qatarHigh": "Qatar High (36kb)",
				"qatarLow": "Qatar Low (16kb)",
				"romaniaHigh": "Romania High (182kb)",
				"romaniaLow": "Romania Low (76kb)",
				"russiaCrimeaHigh": "Russia Crimea High (1mb)",
				"russiaCrimeaLow": "Russia Crimea Low (223kb)",
				"russiaHigh": "Russia High (1mb)",
				"russiaLow": "Russia Low (223kb)",
				"rwandaHigh": "Rwanda High (13kb)",
				"rwandaLow": "Rwanda Low (6kb)",
				"saintHelenaHigh": "Saint Helena High (86kb)",
				"saintHelenaLow": "Saint Helena Low (34kb)",
				"saintLuciaHigh": "Saint Lucia High (56kb)",
				"saintLuciaLow": "Saint Lucia Low (22kb)",
				"saintVincentHigh": "Saint Vincent High (34kb)",
				"saintVincentLow": "Saint Vincent Low (15kb)",
				"samoaHigh": "Samoa High (31kb)",
				"samoaLow": "Samoa Low (15kb)",
				"sanMarinoHigh": "San Marino High (21kb)",
				"sanMarinoLow": "San Marino Low (10kb)",
				"saoTomePrincipeHigh": "Sao Tome Principe High (21kb)",
				"saoTomePrincipeLow": "Sao Tome Principe Low (10kb)",
				"saudiArabiaHigh": "Saudi Arabia High (72kb)",
				"saudiArabiaLow": "Saudi Arabia Low (30kb)",
				"senegalHigh": "Senegal High (120kb)",
				"senegalLow": "Senegal Low (50kb)",
				"serbiaHigh": "Serbia High (54kb)",
				"serbiaLow": "Serbia Low (27kb)",
				"serbiaNoKosovoHigh": "Serbia No Kosovo High (47kb)",
				"serbiaNoKosovoLow": "Serbia No Kosovo Low (23kb)",
				"seychellesHigh": "Seychelles High (130kb)",
				"seychellesLow": "Seychelles Low (57kb)",
				"sierraLeoneHigh": "Sierra Leone High (27kb)",
				"sierraLeoneLow": "Sierra Leone Low (11kb)",
				"singaporeHigh": "Singapore High (82kb)",
				"singaporeLow": "Singapore Low (33kb)",
				"slovakiaHigh": "Slovakia High (119kb)",
				"slovakiaLow": "Slovakia Low (46kb)",
				"sloveniaHigh": "Slovenia High (2mb)",
				"sloveniaLow": "Slovenia Low (617kb)",
				"sloveniaRegionsHigh": "Slovenia Regions High (540kb)",
				"sloveniaRegionsLow": "Slovenia Regions Low (182kb)",
				"solomonIslandsHigh": "Solomon Islands High (384kb)",
				"solomonIslandsLow": "Solomon Islands Low (146kb)",
				"somaliaHigh": "Somalia High (43kb)",
				"somaliaLow": "Somalia Low (20kb)",
				"southAfricaHigh": "South Africa High (56kb)",
				"southAfricaLow": "South Africa Low (23kb)",
				"southKoreaHigh": "South Korea High (254kb)",
				"southKoreaLow": "South Korea Low (108kb)",
				"southSudan2015High": "South Sudan2015 High (276kb)",
				"southSudan2015Low": "South Sudan2015 Low (116kb)",
				"southSudanHigh": "South Sudan High (267kb)",
				"southSudanLow": "South Sudan Low (105kb)",
				"spainHigh": "Spain High (194kb)",
				"spainLow": "Spain Low (76kb)",
				"spain2High": "Spain2 High (720kb)",
				"spain2Low": "Spain2 Low (323kb)",
				"spainProvinces2High": "Spain Provinces2 High (632kb)",
				"spainProvinces2Low": "Spain Provinces2 Low (336kb)",
				"spainProvincesHigh": "Spain Provinces High (474kb)",
				"spainProvincesLow": "Spain Provinces Low (284kb)",
				"sriLankaHigh": "Sri Lanka High (75kb)",
				"sriLankaLow": "Sri Lanka Low (34kb)",
				"stBarthelemyHigh": "ST Barthelemy High (40kb)",
				"stBarthelemyLow": "ST Barthelemy Low (16kb)",
				"stKittsNevisHigh": "ST Kitts Nevis High (18kb)",
				"stKittsNevisLow": "ST Kitts Nevis Low (10kb)",
				"stPierreMiquelonHigh": "ST Pierre Miquelon High (18kb)",
				"stPierreMiquelonLow": "ST Pierre Miquelon Low (7kb)",
				"sudanHigh": "Sudan High (44kb)",
				"sudanLow": "Sudan Low (21kb)",
				"surinameHigh": "Suriname High (24kb)",
				"surinameLow": "Suriname Low (11kb)",
				"svalbardHigh": "Svalbard High (100kb)",
				"svalbardLow": "Svalbard Low (38kb)",
				"swedenHigh": "Sweden High (74kb)",
				"swedenLow": "Sweden Low (32kb)",
				"switzerlandHigh": "Switzerland High (175kb)",
				"switzerlandLow": "Switzerland Low (70kb)",
				"syriaHigh": "Syria High (28kb)",
				"syriaLow": "Syria Low (13kb)",
				"taiwanHigh": "Taiwan High (265kb)",
				"taiwanLow": "Taiwan Low (121kb)",
				"tajikistanHigh": "Tajikistan High (56kb)",
				"tajikistanLow": "Tajikistan Low (22kb)",
				"tanzaniaHigh": "Tanzania High (196kb)",
				"tanzaniaLow": "Tanzania Low (81kb)",
				"thailandHigh": "Thailand High (222kb)",
				"thailandLow": "Thailand Low (97kb)",
				"timorLesteHigh": "Timor Leste High (17kb)",
				"timorLesteLow": "Timor Leste Low (9kb)",
				"togoHigh": "Togo High (14kb)",
				"togoLow": "Togo Low (6kb)",
				"trinidadTobagoHigh": "Trinidad Tobago High (43kb)",
				"trinidadTobagoLow": "Trinidad Tobago Low (19kb)",
				"tunisiaHigh": "Tunisia High (60kb)",
				"tunisiaLow": "Tunisia Low (27kb)",
				"turkeyHigh": "Turkey High (437kb)",
				"turkeyLow": "Turkey Low (183kb)",
				"turkmenistanHigh": "Turkmenistan High (34kb)",
				"turkmenistanLow": "Turkmenistan Low (15kb)",
				"turksCaicosHigh": "Turks Caicos High (305kb)",
				"turksCaicosLow": "Turks Caicos Low (117kb)",
				"uaeHigh": "United Arab Emirates (UAE) High (58kb)",
				"uaeLow": "United Arab Emirates (UAE) Low (26kb)",
				"ugandaHigh": "Uganda High (379kb)",
				"ugandaLow": "Uganda Low (110kb)",
				"ugandaRegionsHigh": "Uganda Regions High (336kb)",
				"ugandaRegionsLow": "Uganda Regions Low (122kb)",
				"ukCountiesHigh": "UK Counties High (87kb)",
				"ukCountiesLow": "UK Counties Low (41kb)",
				"ukCountriesHigh": "UK Countries High (156kb)",
				"ukCountriesLow": "UK Countries Low (61kb)",
				"ukHigh": "UK High (641kb)",
				"ukLow": "UK Low (274kb)",
				"ukraineHigh": "Ukraine High (239kb)",
				"ukraineLow": "Ukraine Low (93kb)",
				"uruguayHigh": "Uruguay High (65kb)",
				"uruguayLow": "Uruguay Low (27kb)",
				"usVirginIslandsHigh": "US Virgin Islands High (99kb)",
				"usVirginIslandsLow": "US Virgin Islands Low (38kb)",
				"uzbekistanHigh": "Uzbekistan High (46kb)",
				"uzbekistanLow": "Uzbekistan Low (21kb)",
				"vaticanHigh": "Vatican High (2kb)",
				"vaticanLow": "Vatican Low (771bb)",
				"venezuelaHigh": "Venezuela High (65kb)",
				"venezuelaLow": "Venezuela Low (30kb)",
				"vietnamHigh": "Vietnam High (252kb)",
				"vietnamLow": "Vietnam Low (108kb)",
				"yemenHigh": "Yemen High (56kb)",
				"yemenLow": "Yemen Low (28kb)",
				"zambiaHigh": "Zambia High (77kb)",
				"zambiaLow": "Zambia Low (31kb)",
				"zimbabweHigh": "Zimbabwe High (63kb)",
				"zimbabweLow": "Zimbabwe Low (25kb)"
			},
			"USA": {
				"usaLow": "USA Low -Recommended- (80kb)",
				"usaHigh": "USA High -Recommended- (184kb)",
				"usaAlbersLow": "USA Albers Low (90kb)",
				"usaAlbersHigh": "USA Albers High (208kb)",
				"usaTerritoriesLow": "USA Territories Low (88kb)",
				"usaTerritoriesHigh": "USA Territories High (204kb)",
				"usaTerritories2Low": "USA Territories2 Low (104kb)",
				"usaTerritories2High": "USA Territories2 High (240kb)",
				"region\/usa\/akAlbersHigh": "Alaska Albers High (783kb)",
				"region\/usa\/akAlbersLow": "Alaska Albers Low (278kb)",
				"region\/usa\/akHigh": "Alaska High (701kb)",
				"region\/usa\/akLow": "Alaska Low (249kb)",
				"region\/usa\/alHigh": "Alabama High (77kb)",
				"region\/usa\/alLow": "Alabama Low (38kb)",
				"region\/usa\/arHigh": "Arkansas High (83kb)",
				"region\/usa\/arLow": "Arkansas Low (41kb)",
				"region\/usa\/azHigh": "Arizona High (39kb)",
				"region\/usa\/azLow": "Arizona Low (16kb)",
				"region\/usa\/caHigh": "California High (158kb)",
				"region\/usa\/caLow": "California Low (64kb)",
				"region\/usa\/coHigh": "Colorado High (64kb)",
				"region\/usa\/coLow": "Colorado Low (33kb)",
				"region\/usa\/ctHigh": "Connecticut High (10kb)",
				"region\/usa\/ctLow": "Connecticut Low (5kb)",
				"region\/usa\/dcHigh": "District of Columbia High (735bb)",
				"region\/usa\/dcLow": "District of Columbia Low (431bb)",
				"region\/usa\/deHigh": "Delaware High (6kb)",
				"region\/usa\/deLow": "Delaware Low (2kb)",
				"region\/usa\/flHigh": "Florida High (149kb)",
				"region\/usa\/flLow": "Florida Low (65kb)",
				"region\/usa\/gaHigh": "Georgia High (396kb)",
				"region\/usa\/gaLow": "Georgia Low (161kb)",
				"region\/usa\/hiAlbersHigh": "Hawaii Albers High (26kb)",
				"region\/usa\/hiAlbersLow": "Hawaii Albers Low (10kb)",
				"region\/usa\/hiHigh": "Hawaii High (9kb)",
				"region\/usa\/hiLow": "Hawaii Low (4kb)",
				"region\/usa\/iaHigh": "Iowa High (44kb)",
				"region\/usa\/iaLow": "Iowa Low (31kb)",
				"region\/usa\/idHigh": "Idaho High (84kb)",
				"region\/usa\/idLow": "Idaho Low (36kb)",
				"region\/usa\/ilHigh": "Illinois High (71kb)",
				"region\/usa\/ilLow": "Illinois Low (42kb)",
				"region\/usa\/inHigh": "Indiana High (53kb)",
				"region\/usa\/inLow": "Indiana Low (34kb)",
				"region\/usa\/ksHigh": "Kansas High (38kb)",
				"region\/usa\/ksLow": "Kansas Low (32kb)",
				"region\/usa\/kyHigh": "Kentucky High (108kb)",
				"region\/usa\/kyLow": "Kentucky Low (57kb)",
				"region\/usa\/laHigh": "Louisiana High (150kb)",
				"region\/usa\/laLow": "Louisiana Low (65kb)",
				"region\/usa\/maHigh": "Massachusetts High (23kb)",
				"region\/usa\/maLow": "Massachusetts Low (10kb)",
				"region\/usa\/mdHigh": "Maryland High (65kb)",
				"region\/usa\/mdLow": "Maryland Low (27kb)",
				"region\/usa\/meHigh": "Maine High (58kb)",
				"region\/usa\/meLow": "Maine Low (24kb)",
				"region\/usa\/miHigh": "Michigan High (76kb)",
				"region\/usa\/miLow": "Michigan Low (40kb)",
				"region\/usa\/mnHigh": "Minnesota High (75kb)",
				"region\/usa\/mnLow": "Minnesota Low (42kb)",
				"region\/usa\/moHigh": "Missouri High (105kb)",
				"region\/usa\/moLow": "Missouri Low (56kb)",
				"region\/usa\/msHigh": "Mississippi High (56kb)",
				"region\/usa\/msLow": "Mississippi Low (34kb)",
				"region\/usa\/mtHigh": "Montana High (97kb)",
				"region\/usa\/mtLow": "Montana Low (43kb)",
				"region\/usa\/ncHigh": "North Carolina High (147kb)",
				"region\/usa\/ncLow": "North Carolina Low (70kb)",
				"region\/usa\/ndHigh": "North Dakota High (50kb)",
				"region\/usa\/ndLow": "North Dakota Low (27kb)",
				"region\/usa\/neHigh": "Nebraska High (41kb)",
				"region\/usa\/neLow": "Nebraska Low (30kb)",
				"region\/usa\/nhHigh": "New Hampshire High (17kb)",
				"region\/usa\/nhLow": "New Hampshire Low (8kb)",
				"region\/usa\/njHigh": "New Jersey High (36kb)",
				"region\/usa\/njLow": "New Jersey Low (16kb)",
				"region\/usa\/nmHigh": "New Mexico High (29kb)",
				"region\/usa\/nmLow": "New Mexico Low (16kb)",
				"region\/usa\/nvHigh": "Nevada High (25kb)",
				"region\/usa\/nvLow": "Nevada Low (11kb)",
				"region\/usa\/nyHigh": "New York High (65kb)",
				"region\/usa\/nyLow": "New York Low (34kb)",
				"region\/usa\/ohHigh": "Ohio High (49kb)",
				"region\/usa\/ohLow": "Ohio Low (33kb)",
				"region\/usa\/okHigh": "Oklahoma High (51kb)",
				"region\/usa\/okLow": "Oklahoma Low (31kb)",
				"region\/usa\/orHigh": "Oregon High (96kb)",
				"region\/usa\/orLow": "Oregon Low (40kb)",
				"region\/usa\/paHigh": "Pennsylvania High (89kb)",
				"region\/usa\/paLow": "Pennsylvania Low (41kb)",
				"region\/usa\/riHigh": "Rhoe Island High (5kb)",
				"region\/usa\/riLow": "Rhoe Island Low (3kb)",
				"region\/usa\/scHigh": "South Carolina High (69kb)",
				"region\/usa\/scLow": "South Carolina Low (32kb)",
				"region\/usa\/sdHigh": "South Dakota High (44kb)",
				"region\/usa\/sdLow": "South Dakota Low (27kb)",
				"region\/usa\/tnHigh": "Tennessee High (85kb)",
				"region\/usa\/tnLow": "Tennessee Low (45kb)",
				"region\/usa\/txHigh": "Texas High (227kb)",
				"region\/usa\/txLow": "Texas Low (124kb)",
				"region\/usa\/utHigh": "Utah High (48kb)",
				"region\/usa\/utLow": "Utah Low (21kb)",
				"region\/usa\/vaHigh": "Virginia High (157kb)",
				"region\/usa\/vaLow": "Virginia Low (78kb)",
				"region\/usa\/vtHigh": "Vermont High (18kb)",
				"region\/usa\/vtLow": "Vermont Low (9kb)",
				"region\/usa\/waHigh": "Washington High (102kb)",
				"region\/usa\/waLow": "Washington Low (43kb)",
				"region\/usa\/wiHigh": "Wisconsin High (60kb)",
				"region\/usa\/wiLow": "Wisconsin Low (33kb)",
				"region\/usa\/wvHigh": "West Virginia High (80kb)",
				"region\/usa\/wvLow": "West Virginia Low (36kb)",
				"region\/usa\/wyHigh": "Wyoming High (22kb)",
				"region\/usa\/wyLow": "Wyoming Low (12kb)",
				"region\/usa\/congressional\/akHigh": "Alaska High Congressional (78kb)",
				"region\/usa\/congressional\/akLow": "Alaska Low Congressional (27kb)",
				"region\/usa\/congressional\/alHigh": "Alabama High Congressional (522kb)",
				"region\/usa\/congressional\/alLow": "Alabama Low Congressional (177kb)",
				"region\/usa\/congressional\/arHigh": "Arkansas High Congressional (241kb)",
				"region\/usa\/congressional\/arLow": "Arkansas Low Congressional (88kb)",
				"region\/usa\/congressional\/azHigh": "Arizona High Congressional (160kb)",
				"region\/usa\/congressional\/azLow": "Arizona Low Congressional (55kb)",
				"region\/usa\/congressional\/caHigh": "California High Congressional (1mb)",
				"region\/usa\/congressional\/caLow": "California Low Congressional (498kb)",
				"region\/usa\/congressional\/coHigh": "Colorado High Congressional (301kb)",
				"region\/usa\/congressional\/coLow": "Colorado Low Congressional (110kb)",
				"region\/usa\/congressional\/ctHigh": "Connecticut High Congressional (87kb)",
				"region\/usa\/congressional\/ctLow": "Connecticut Low Congressional (37kb)",
				"region\/usa\/congressional\/dcHigh": "District of Columbia High Congressional (10kb)",
				"region\/usa\/congressional\/dcLow": "District of Columbia Low Congressional (7kb)",
				"region\/usa\/congressional\/deHigh": "Delaware High Congressional (15kb)",
				"region\/usa\/congressional\/deLow": "Delaware Low Congressional (6kb)",
				"region\/usa\/congressional\/flHigh": "Florida High Congressional (675kb)",
				"region\/usa\/congressional\/flLow": "Florida Low Congressional (227kb)",
				"region\/usa\/congressional\/gaHigh": "Georgia High Congressional (599kb)",
				"region\/usa\/congressional\/gaLow": "Georgia Low Congressional (232kb)",
				"region\/usa\/congressional\/hiHigh": "Hawaii High Congressional (29kb)",
				"region\/usa\/congressional\/hiLow": "Hawaii Low Congressional (10kb)",
				"region\/usa\/congressional\/iaHigh": "Iowa High Congressional (178kb)",
				"region\/usa\/congressional\/iaLow": "Iowa Low Congressional (62kb)",
				"region\/usa\/congressional\/idHigh": "Idaho High Congressional (301kb)",
				"region\/usa\/congressional\/idLow": "Idaho Low Congressional (106kb)",
				"region\/usa\/congressional\/ilHigh": "Illinois High Congressional (533kb)",
				"region\/usa\/congressional\/ilLow": "Illinois Low Congressional (201kb)",
				"region\/usa\/congressional\/inHigh": "Indiana High Congressional (198kb)",
				"region\/usa\/congressional\/inLow": "Indiana Low Congressional (70kb)",
				"region\/usa\/congressional\/ksHigh": "Kansas High Congressional (142kb)",
				"region\/usa\/congressional\/ksLow": "Kansas Low Congressional (48kb)",
				"region\/usa\/congressional\/kyHigh": "Kentucky High Congressional (410kb)",
				"region\/usa\/congressional\/kyLow": "Kentucky Low Congressional (146kb)",
				"region\/usa\/congressional\/laHigh": "Louisiana High Congressional (479kb)",
				"region\/usa\/congressional\/laLow": "Louisiana Low Congressional (174kb)",
				"region\/usa\/congressional\/maHigh": "Massachusetts High Congressional (232kb)",
				"region\/usa\/congressional\/maLow": "Massachusetts Low Congressional (79kb)",
				"region\/usa\/congressional\/mdHigh": "Maryland High Congressional (605kb)",
				"region\/usa\/congressional\/mdLow": "Maryland Low Congressional (204kb)",
				"region\/usa\/congressional\/meHigh": "Maine High Congressional (189kb)",
				"region\/usa\/congressional\/meLow": "Maine Low Congressional (62kb)",
				"region\/usa\/congressional\/miHigh": "Michigan High Congressional (241kb)",
				"region\/usa\/congressional\/miLow": "Michigan Low Congressional (80kb)",
				"region\/usa\/congressional\/mnHigh": "Minnesota High Congressional (217kb)",
				"region\/usa\/congressional\/mnLow": "Minnesota Low Congressional (79kb)",
				"region\/usa\/congressional\/moHigh": "Missouri High Congressional (333kb)",
				"region\/usa\/congressional\/moLow": "Missouri Low Congressional (122kb)",
				"region\/usa\/congressional\/msHigh": "Mississippi High Congressional (237kb)",
				"region\/usa\/congressional\/msLow": "Mississippi Low Congressional (85kb)",
				"region\/usa\/congressional\/mtHigh": "Montana High Congressional (139kb)",
				"region\/usa\/congressional\/mtLow": "Montana Low Congressional (49kb)",
				"region\/usa\/congressional\/ncHigh": "North Carolina High Congressional (688kb)",
				"region\/usa\/congressional\/ncLow": "North Carolina Low Congressional (325kb)",
				"region\/usa\/congressional\/ndHigh": "North Dakota High Congressional (133kb)",
				"region\/usa\/congressional\/ndLow": "North Dakota Low Congressional (53kb)",
				"region\/usa\/congressional\/neHigh": "Nebraska High Congressional (115kb)",
				"region\/usa\/congressional\/neLow": "Nebraska Low Congressional (38kb)",
				"region\/usa\/congressional\/nhHigh": "New Hampshire High Congressional (126kb)",
				"region\/usa\/congressional\/nhLow": "New Hampshire Low Congressional (48kb)",
				"region\/usa\/congressional\/njHigh": "New Jersey High Congressional (520kb)",
				"region\/usa\/congressional\/njLow": "New Jersey Low Congressional (171kb)",
				"region\/usa\/congressional\/nmHigh": "New Mexico High Congressional (124kb)",
				"region\/usa\/congressional\/nmLow": "New Mexico Low Congressional (45kb)",
				"region\/usa\/congressional\/nvHigh": "Nevada High Congressional (118kb)",
				"region\/usa\/congressional\/nvLow": "Nevada Low Congressional (42kb)",
				"region\/usa\/congressional\/nyHigh": "New York High Congressional (316kb)",
				"region\/usa\/congressional\/nyLow": "New York Low Congressional (116kb)",
				"region\/usa\/congressional\/ohHigh": "Ohio High Congressional (477kb)",
				"region\/usa\/congressional\/ohLow": "Ohio Low Congressional (184kb)",
				"region\/usa\/congressional\/okHigh": "Oklahoma High Congressional (256kb)",
				"region\/usa\/congressional\/okLow": "Oklahoma Low Congressional (91kb)",
				"region\/usa\/congressional\/orHigh": "Oregon High Congressional (319kb)",
				"region\/usa\/congressional\/orLow": "Oregon Low Congressional (113kb)",
				"region\/usa\/congressional\/paHigh": "Pennsylvania High Congressional (463kb)",
				"region\/usa\/congressional\/paLow": "Pennsylvania Low Congressional (188kb)",
				"region\/usa\/congressional\/riHigh": "Rhoe Island High Congressional (28kb)",
				"region\/usa\/congressional\/riLow": "Rhoe Island Low Congressional (10kb)",
				"region\/usa\/congressional\/scHigh": "South Carolina High Congressional (125kb)",
				"region\/usa\/congressional\/scLow": "South Carolina Low Congressional (43kb)",
				"region\/usa\/congressional\/sdHigh": "South Dakota High Congressional (86kb)",
				"region\/usa\/congressional\/sdLow": "South Dakota Low Congressional (33kb)",
				"region\/usa\/congressional\/tnHigh": "Tennessee High Congressional (502kb)",
				"region\/usa\/congressional\/tnLow": "Tennessee Low Congressional (208kb)",
				"region\/usa\/congressional\/txHigh": "Texas High Congressional (674kb)",
				"region\/usa\/congressional\/txLow": "Texas Low Congressional (232kb)",
				"region\/usa\/congressional\/utHigh": "Utah High Congressional (255kb)",
				"region\/usa\/congressional\/utLow": "Utah Low Congressional (96kb)",
				"region\/usa\/congressional\/vaHigh": "Virginia High Congressional (612kb)",
				"region\/usa\/congressional\/vaLow": "Virginia Low Congressional (230kb)",
				"region\/usa\/congressional\/vtHigh": "Vermont High Congressional (57kb)",
				"region\/usa\/congressional\/vtLow": "Vermont Low Congressional (20kb)",
				"region\/usa\/congressional\/waHigh": "Washington High Congressional (470kb)",
				"region\/usa\/congressional\/waLow": "Washington Low Congressional (152kb)",
				"region\/usa\/congressional\/wiHigh": "Wisconsin High Congressional (275kb)",
				"region\/usa\/congressional\/wiLow": "Wisconsin Low Congressional (101kb)",
				"region\/usa\/congressional\/wvHigh": "West Virginia High Congressional (298kb)",
				"region\/usa\/congressional\/wvLow": "West Virginia Low Congressional (109kb)",
				"region\/usa\/congressional\/wyHigh": "Wyoming High Congressional (42kb)",
				"region\/usa\/congressional\/wyLow": "Wyoming Low Congressional (15kb)",
				"region\/usa\/congressional2022\/akHigh": "Alaska High Congressional 2022 (87kb)",
				"region\/usa\/congressional2022\/akLow": "Alaska Low Congressional 2022 (31kb)",
				"region\/usa\/congressional2022\/alHigh": "Alabama High Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/alLow": "Alabama Low Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/arHigh": "Arkansas High Congressional 2022 (5kb)",
				"region\/usa\/congressional2022\/arLow": "Arkansas Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/azHigh": "Arizona High Congressional 2022 (8kb)",
				"region\/usa\/congressional2022\/azLow": "Arizona Low Congressional 2022 (5kb)",
				"region\/usa\/congressional2022\/caHigh": "California High Congressional 2022 (38kb)",
				"region\/usa\/congressional2022\/caLow": "California Low Congressional 2022 (24kb)",
				"region\/usa\/congressional2022\/coHigh": "Colorado High Congressional 2022 (6kb)",
				"region\/usa\/congressional2022\/coLow": "Colorado Low Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/ctHigh": "Connecticut High Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/ctLow": "Connecticut Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/dcHigh": "District of Columbia High Congressional 2022 (452bb)",
				"region\/usa\/congressional2022\/dcLow": "District of Columbia Low Congressional 2022 (358bb)",
				"region\/usa\/congressional2022\/deHigh": "Delaware High Congressional 2022 (749bb)",
				"region\/usa\/congressional2022\/deLow": "Delaware Low Congressional 2022 (452bb)",
				"region\/usa\/congressional2022\/flHigh": "Florida High Congressional 2022 (16kb)",
				"region\/usa\/congressional2022\/flLow": "Florida Low Congressional 2022 (11kb)",
				"region\/usa\/congressional2022\/gaHigh": "Georgia High Congressional 2022 (11kb)",
				"region\/usa\/congressional2022\/gaLow": "Georgia Low Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/hiHigh": "Hawaii High Congressional 2022 (32kb)",
				"region\/usa\/congressional2022\/hiLow": "Hawaii Low Congressional 2022 (12kb)",
				"region\/usa\/congressional2022\/iaHigh": "Iowa High Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/iaLow": "Iowa Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/idHigh": "Idaho High Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/idLow": "Idaho Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/ilHigh": "Illinois High Congressional 2022 (13kb)",
				"region\/usa\/congressional2022\/ilLow": "Illinois Low Congressional 2022 (8kb)",
				"region\/usa\/congressional2022\/inHigh": "Indiana High Congressional 2022 (6kb)",
				"region\/usa\/congressional2022\/inLow": "Indiana Low Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/ksHigh": "Kansas High Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/ksLow": "Kansas Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/kyHigh": "Kentucky High Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/kyLow": "Kentucky Low Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/laHigh": "Louisiana High Congressional 2022 (10kb)",
				"region\/usa\/congressional2022\/laLow": "Louisiana Low Congressional 2022 (5kb)",
				"region\/usa\/congressional2022\/maHigh": "Massachusetts High Congressional 2022 (6kb)",
				"region\/usa\/congressional2022\/maLow": "Massachusetts Low Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/mdHigh": "Maryland High Congressional 2022 (6kb)",
				"region\/usa\/congressional2022\/mdLow": "Maryland Low Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/meHigh": "Maine High Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/meLow": "Maine Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/miHigh": "Michigan High Congressional 2022 (10kb)",
				"region\/usa\/congressional2022\/miLow": "Michigan Low Congressional 2022 (6kb)",
				"region\/usa\/congressional2022\/mnHigh": "Minnesota High Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/mnLow": "Minnesota Low Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/moHigh": "Missouri High Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/moLow": "Missouri Low Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/msHigh": "Mississippi High Congressional 2022 (5kb)",
				"region\/usa\/congressional2022\/msLow": "Mississippi Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/mtHigh": "Montana High Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/mtLow": "Montana Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/ncHigh": "North Carolina High Congressional 2022 (12kb)",
				"region\/usa\/congressional2022\/ncLow": "North Carolina Low Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/ndHigh": "North Dakota High Congressional 2022 (1kb)",
				"region\/usa\/congressional2022\/ndLow": "North Dakota Low Congressional 2022 (631bb)",
				"region\/usa\/congressional2022\/neHigh": "Nebraska High Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/neLow": "Nebraska Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/nhHigh": "New Hampshire High Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/nhLow": "New Hampshire Low Congressional 2022 (1kb)",
				"region\/usa\/congressional2022\/njHigh": "New Jersey High Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/njLow": "New Jersey Low Congressional 2022 (5kb)",
				"region\/usa\/congressional2022\/nmHigh": "New Mexico High Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/nmLow": "New Mexico Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/nvHigh": "Nevada High Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/nvLow": "Nevada Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/nyHigh": "New York High Congressional 2022 (14kb)",
				"region\/usa\/congressional2022\/nyLow": "New York Low Congressional 2022 (10kb)",
				"region\/usa\/congressional2022\/ohHigh": "Ohio High Congressional 2022 (9kb)",
				"region\/usa\/congressional2022\/ohLow": "Ohio Low Congressional 2022 (6kb)",
				"region\/usa\/congressional2022\/okHigh": "Oklahoma High Congressional 2022 (5kb)",
				"region\/usa\/congressional2022\/okLow": "Oklahoma Low Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/orHigh": "Oregon High Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/orLow": "Oregon Low Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/paHigh": "Pennsylvania High Congressional 2022 (11kb)",
				"region\/usa\/congressional2022\/paLow": "Pennsylvania Low Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/riHigh": "Rhoe Island High Congressional 2022 (1kb)",
				"region\/usa\/congressional2022\/riLow": "Rhoe Island Low Congressional 2022 (737bb)",
				"region\/usa\/congressional2022\/scHigh": "South Carolina High Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/scLow": "South Carolina Low Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/sdHigh": "South Dakota High Congressional 2022 (1kb)",
				"region\/usa\/congressional2022\/sdLow": "South Dakota Low Congressional 2022 (572bb)",
				"region\/usa\/congressional2022\/tnHigh": "Tennessee High Congressional 2022 (8kb)",
				"region\/usa\/congressional2022\/tnLow": "Tennessee Low Congressional 2022 (5kb)",
				"region\/usa\/congressional2022\/txHigh": "Texas High Congressional 2022 (32kb)",
				"region\/usa\/congressional2022\/txLow": "Texas Low Congressional 2022 (20kb)",
				"region\/usa\/congressional2022\/utHigh": "Utah High Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/utLow": "Utah Low Congressional 2022 (2kb)",
				"region\/usa\/congressional2022\/vaHigh": "Virginia High Congressional 2022 (10kb)",
				"region\/usa\/congressional2022\/vaLow": "Virginia Low Congressional 2022 (5kb)",
				"region\/usa\/congressional2022\/vtHigh": "Vermont High Congressional 2022 (1kb)",
				"region\/usa\/congressional2022\/vtLow": "Vermont Low Congressional 2022 (676bb)",
				"region\/usa\/congressional2022\/waHigh": "Washington High Congressional 2022 (10kb)",
				"region\/usa\/congressional2022\/waLow": "Washington Low Congressional 2022 (6kb)",
				"region\/usa\/congressional2022\/wiHigh": "Wisconsin High Congressional 2022 (7kb)",
				"region\/usa\/congressional2022\/wiLow": "Wisconsin Low Congressional 2022 (4kb)",
				"region\/usa\/congressional2022\/wvHigh": "West Virginia High Congressional 2022 (3kb)",
				"region\/usa\/congressional2022\/wvLow": "West Virginia Low Congressional 2022 (1kb)",
				"region\/usa\/congressional2022\/wyHigh": "Wyoming High Congressional 2022 (1kb)",
				"region\/usa\/congressional2022\/wyLow": "Wyoming Low Congressional 2022 (576bb)"
			},
			"Canada": {
				"region\/canada\/abHigh": "AB High (53kb)",
				"region\/canada\/abLow": "AB Low (24kb)",
				"region\/canada\/bcHigh": "BC High (188kb)",
				"region\/canada\/bcLow": "BC Low (80kb)",
				"region\/canada\/canadaCountiesHigh": "Canada Counties High (550kb)",
				"region\/canada\/canadaCountiesLow": "Canada Counties Low (250kb)",
				"region\/canada\/mbHigh": "MB High (32kb)",
				"region\/canada\/mbLow": "MB Low (16kb)",
				"region\/canada\/nbHigh": "NB High (17kb)",
				"region\/canada\/nbLow": "NB Low (9kb)",
				"region\/canada\/nlHigh": "NL High (118kb)",
				"region\/canada\/nlLow": "NL Low (48kb)",
				"region\/canada\/nsHigh": "NS High (27kb)",
				"region\/canada\/nsLow": "NS Low (13kb)",
				"region\/canada\/ntHigh": "NT High (82kb)",
				"region\/canada\/ntLow": "NT Low (33kb)",
				"region\/canada\/nuHigh": "NU High (431kb)",
				"region\/canada\/nuLow": "NU Low (163kb)",
				"region\/canada\/onHigh": "ON High (93kb)",
				"region\/canada\/onLow": "ON Low (47kb)",
				"region\/canada\/peHigh": "PE High (4kb)",
				"region\/canada\/peLow": "PE Low (2kb)",
				"region\/canada\/qcHigh": "QC High (173kb)",
				"region\/canada\/qcLow": "QC Low (85kb)",
				"region\/canada\/skHigh": "SK High (22kb)",
				"region\/canada\/skLow": "SK Low (11kb)",
				"region\/canada\/ytHigh": "YT High (11kb)",
				"region\/canada\/ytLow": "YT Low (4kb)"
			},
			"Mexico": {
				"region\/mexico\/agsHigh": "Ags High (34kb)",
				"region\/mexico\/agsLow": "Ags Low (15kb)",
				"region\/mexico\/bcnHigh": "Bcn High (70kb)",
				"region\/mexico\/bcnLow": "Bcn Low (28kb)",
				"region\/mexico\/bcsHigh": "Bcs High (51kb)",
				"region\/mexico\/bcsLow": "Bcs Low (21kb)",
				"region\/mexico\/camHigh": "Cam High (43kb)",
				"region\/mexico\/camLow": "Cam Low (19kb)",
				"region\/mexico\/chhHigh": "Chh High (141kb)",
				"region\/mexico\/chhLow": "Chh Low (67kb)",
				"region\/mexico\/chpHigh": "Chp High (142kb)",
				"region\/mexico\/chpLow": "Chp Low (77kb)",
				"region\/mexico\/cmxHigh": "Cmx High (49kb)",
				"region\/mexico\/cmxLow": "Cmx Low (21kb)",
				"region\/mexico\/coaHigh": "Coa High (77kb)",
				"region\/mexico\/coaLow": "Coa Low (38kb)",
				"region\/mexico\/colHigh": "Col High (63kb)",
				"region\/mexico\/colLow": "Col Low (26kb)",
				"region\/mexico\/durHigh": "Dur High (79kb)",
				"region\/mexico\/durLow": "Dur Low (37kb)",
				"region\/mexico\/groHigh": "Gro High (136kb)",
				"region\/mexico\/groLow": "Gro Low (67kb)",
				"region\/mexico\/guaHigh": "Gua High (78kb)",
				"region\/mexico\/guaLow": "Gua Low (39kb)",
				"region\/mexico\/hidHigh": "Hid High (138kb)",
				"region\/mexico\/hidLow": "Hid Low (68kb)",
				"region\/mexico\/jalHigh": "Jal High (278kb)",
				"region\/mexico\/jalLow": "Jal Low (129kb)",
				"region\/mexico\/mexHigh": "Mex High (150kb)",
				"region\/mexico\/mexLow": "Mex Low (81kb)",
				"region\/mexico\/mexicoCountiesHigh": "Mexico Counties High (2mb)",
				"region\/mexico\/mexicoCountiesLow": "Mexico Counties Low (1mb)",
				"region\/mexico\/mexicoCountiesUltra": "Mexico Counties Ultra (3mb)",
				"region\/mexico\/micHigh": "Mic High (187kb)",
				"region\/mexico\/micLow": "Mic Low (94kb)",
				"region\/mexico\/morHigh": "Mor High (163kb)",
				"region\/mexico\/morLow": "Mor Low (65kb)",
				"region\/mexico\/nayHigh": "Nay High (53kb)",
				"region\/mexico\/nayLow": "Nay Low (24kb)",
				"region\/mexico\/nleHigh": "Nle High (85kb)",
				"region\/mexico\/nleLow": "Nle Low (41kb)",
				"region\/mexico\/oaxHigh": "Oax High (383kb)",
				"region\/mexico\/oaxLow": "Oax Low (261kb)",
				"region\/mexico\/pueHigh": "Pue High (318kb)",
				"region\/mexico\/pueLow": "Pue Low (162kb)",
				"region\/mexico\/queHigh": "Que High (45kb)",
				"region\/mexico\/queLow": "Que Low (21kb)",
				"region\/mexico\/rooHigh": "Roo High (56kb)",
				"region\/mexico\/rooLow": "Roo Low (25kb)",
				"region\/mexico\/sinHigh": "Sin High (75kb)",
				"region\/mexico\/sinLow": "Sin Low (31kb)",
				"region\/mexico\/slpHigh": "Slp High (103kb)",
				"region\/mexico\/slpLow": "Slp Low (51kb)",
				"region\/mexico\/sonHigh": "Son High (78kb)",
				"region\/mexico\/sonLow": "Son Low (43kb)",
				"region\/mexico\/tabHigh": "Tab High (91kb)",
				"region\/mexico\/tabLow": "Tab Low (37kb)",
				"region\/mexico\/tamHigh": "Tam High (71kb)",
				"region\/mexico\/tamLow": "Tam Low (35kb)",
				"region\/mexico\/tlaHigh": "Tla High (62kb)",
				"region\/mexico\/tlaLow": "Tla Low (35kb)",
				"region\/mexico\/verHigh": "Ver High (344kb)",
				"region\/mexico\/verLow": "Ver Low (174kb)",
				"region\/mexico\/yucHigh": "Yuc High (79kb)",
				"region\/mexico\/yucLow": "Yuc Low (50kb)",
				"region\/mexico\/zacHigh": "Zac High (101kb)",
				"region\/mexico\/zacLow": "Zac Low (49kb)"
			}
		}';

		$this->maps = apply_filters( 'igm_map_list_json', $json );
	}
}
