<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\HomListi_Core;

use radiustheme\HomListi\Helper;
use radiustheme\HomListi\Listing_Functions;
use Rtcl\Helpers\Functions;
use RtclPro\Helpers\Fns;
use RtclPro\Controllers\Hooks\TemplateHooks;

$size = $data['thumbnail_size'] ? $data['thumbnail_size'] : 'rtcl-thumbnail';

$uniqueid = time() . rand( 1, 99 );
$count    = 0;

$display = [
	'cat'    => $data['cat_display'] ? true : false,
	'views'  => $data['views_display'] ? true : false,
	'fields' => $data['field_display'] === 'yes' ? true : false,
	'label'  => $data['label_display'] === 'yes' ? true : false,
	'author' => $data['author_display'] === 'yes' ? true : false,
	'type'   => true,
];

$gird_column_desktop = ( isset( $data['gird_column_desktop'] ) ? $data['gird_column_desktop'] : '4' );
$gird_column_tab     = ( isset( $data['gird_column_desktop_tablet'] ) && ! empty( $data['gird_column_desktop_tablet'] ) ) ? $data['gird_column_desktop_tablet'] : '6';
$gird_column_mobile  = ( isset( $data['gird_column_desktop_mobile'] ) && ! empty( $data['gird_column_desktop_mobile'] ) ) ? $data['gird_column_desktop_mobile'] : '6';

$col_class  = "col-lg-{$gird_column_desktop} col-md-{$gird_column_tab} col-sm-{$gird_column_mobile}";
$has_footer = $data['show_listing_footer'] ? 'has-listing-footer' : 'no-listing-footer';
?>
    <div class="rt-el-listing-wrapper isotope-wrap product-grid <?php echo esc_attr( $data['layout'] . ' ' . $has_footer . ' ' . $data['hanging_visibility'] ) ?>" id="inner-isotope">
        <div class="filter-wrapper">
            <div class="isotope-classes-tab">

				<?php if ( $data['show_all_btn'] ) : ?>
                    <a class="nav-item current" data-filter="*"><?php echo esc_html__( 'All Type', 'homlisti-core' ); ?></a>
				<?php endif; ?>

				<?php foreach ( $data['navs'] as $key => $value ): ?>
                    <a class="nav-item <?php echo ( ! $count && ! $data['show_all_btn'] ) ? 'current' : '';
					$count ++; ?>" data-filter=".<?php echo esc_attr( $key . $uniqueid ); ?>"><?php echo esc_html( $value ); ?></a>
				<?php endforeach; ?>
            </div>
        </div>

        <div class="row featuredContainer">
			<?php foreach ( $data['queries'] as $key => $query ): ?>
				<?php if ( $query->have_posts() ) : ?>
					<?php while ( $query->have_posts() ) : $query->the_post(); ?>
						<?php
						global $listing;
						$listing_type = Listing_Functions::get_listing_type( $listing );
						$thumb_img    = wp_get_attachment_image_src( $listing->get_the_thumbnail_id(), $size );
						$images       = Functions::get_listing_images( $listing->get_id() );
						?>
                        <div class="<?php echo esc_attr( $col_class . ' ' . $key . $uniqueid ); ?>">
                            <div class="product-box style2">
								<?php if ( $data['listing_thumb_visibility'] === 'yes' ) : ?>
                                    <div class="product-thumb">

										<?php if ( 'slider' !== $data['thumbnail_source'] ) : ?>
                                            <a href="<?php the_permalink(); ?>"><?php $listing->the_thumbnail(); ?></a>
										<?php else :
											Helper::homlisti_thumb_carousel( $listing->get_id(), $size );
										endif; ?>

										<?php $type_hide = ( $data['type_visibility'] != 'yes' || empty( $listing_type ) ) ? 'hide-product-type' : null; ?>
                                        <div class="product-type <?php echo esc_attr( $type_hide ) ?>">
											<?php if ( $data['type_visibility'] && ! empty( $listing_type ) ): ?>
                                                <span class="listing-type-badge">
                                            <?php echo sprintf( "%s %s", apply_filters( 'rtcl_type_prefix', __( 'For', 'homlisti-core' ) ), $listing_type['label'] ); ?>
                                            </span>
											<?php endif; ?>


                                        </div>

										<?php if ( $display['label'] && $data['label_position'] == 'thumb' ):
											$listing->the_badges();
										endif; ?>

										<?php if ( $listing->can_show_price() ): ?>
                                            <div class="product-price"><?php echo $listing->get_price_html(); ?></div>
										<?php endif; ?>

										<?php if ( $data['listing_action_visibility'] ) : ?>
                                            <div class="listing-action">
												<?php echo Listing_Functions::get_favourites_link( $listing->get_id() ); ?>
												<?php if ( Fns::is_enable_compare() ) {
													$compare_ids    = ! empty( $_SESSION['rtcl_compare_ids'] ) ? $_SESSION['rtcl_compare_ids'] : [];
													$selected_class = '';
													if ( is_array( $compare_ids ) && in_array( $listing->get_id(), $compare_ids ) ) {
														$selected_class = ' selected';
													}
													?>
                                                    <a class="rtcl-compare <?php echo esc_attr( $selected_class ); ?>" href="#" data-toggle="tooltip" data-placement="top" title=""
                                                       data-original-title="<?php esc_html_e( "Compare", "homlisti-core" ) ?>"
                                                       data-listing_id="<?php echo absint( $listing->get_id() ) ?>">
                                                        <i class="flaticon-left-and-right-arrows"></i>
                                                    </a>
												<?php } ?>
                                            </div>
										<?php endif; ?>
                                    </div>
								<?php endif; ?>
                                <div class="product-content">
                                    <div class="product-top-content">
										<?php
										if ( $listing->has_category() && $display['cat'] ):
											$category = $listing->get_categories();
											$category = end( $category );
											?>
                                            <div class="product-category">
                                                <a href="<?php echo esc_url( get_term_link( $category->term_id,
													$category->taxonomy ) ); ?>"><?php echo esc_html( $category->name ) ?></a>
                                            </div>
										<?php endif;
										?>
										<?php if ( $listing->get_the_title() ): ?>
                                            <h3 class="item-title rt-main-title">
                                                <a href="<?php $listing->the_permalink(); ?>">
													<?php $listing->the_title(); ?>
                                                </a>
                                            </h3>
										<?php endif; ?>

										<?php if ( $display['label'] && $data['label_position'] == 'below_title' ):
											$listing->the_badges();
										endif; ?>

                                        <ul class="entry-meta">
											<?php if ( $listing->has_location() && $listing->can_show_location() && $data['location_visibility'] ): ?>
                                                <li><i class="fas fa-map-marker-alt"></i><?php $listing->the_locations(); ?></li>
											<?php endif; ?>

											<?php if ( $listing->can_show_date() && $data['date_visibility'] ): ?>
                                                <li class="updated"><i class="far fa-clock"></i><?php $listing->the_time(); ?></li>
											<?php endif; ?>

											<?php if ( $display['views'] ): ?>
                                                <li class="rt-views">
                                                    <i class="far fa-eye"></i><?php echo sprintf( _n( "%s view", "%s views", $listing->get_view_counts(), 'homlisti-core' ),
														number_format_i18n( $listing->get_view_counts() ) ); ?>
                                                </li>
											<?php endif; ?>
                                        </ul>

										<?php if ( $data['content_visibility'] ) : ?>
                                            <div class="listing-content">
												<?php
												$content = strip_shortcodes( wp_strip_all_tags( $listing->get_the_content() ) );
												$content = wp_trim_words( $content, $data['content_limit'], '' );
												echo wp_kses_post( $content );
												?>
                                            </div>
										<?php endif; ?>

										<?php
										if ( $display['fields'] ) { ?>
                                            <div class="list-information <?php echo esc_attr( $data['info_style'] ) ?>">
												<?php TemplateHooks::loop_item_listable_fields(); ?>
                                            </div>
										<?php }
										?>

                                    </div>

									<?php if ( $data['show_listing_footer'] ) : ?>
                                        <div class="product-bottom-content">
                                            <ul>
												<?php if ( $display['author'] && method_exists( $listing, 'get_the_author_url' ) ): ?>
                                                    <li class="item-author">
                                                        <div class="media">
                                                            <div class="item-img">
																<?php Helper::get_listing_author_iamge( $listing ); ?>
                                                            </div>
                                                            <div class="media-body">
                                                                <div class="item-title">
																	<?php if ( $data['author_prefix'] ) : ?>
                                                                        <span><?php echo esc_html( $data['author_prefix'] ); ?></span>
																	<?php endif; ?>
																	<?php if ( $listing->can_add_user_link() && ! is_author() ) : ?>
                                                                        <a class="author-link" href="<?php echo esc_url( $listing->get_the_author_url() ); ?>">
																			<?php echo esc_html( $listing->get_author_name() ); ?>
																			<?php do_action( 'rtcl_after_author_meta', $listing->get_owner_id() ); ?>
                                                                        </a>
																	<?php else: ?>
																		<?php echo $listing->get_author_name(); ?>
																	<?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
												<?php endif; ?>
                                                <li class="action-btn">
                                                    <a class="btn btn-primary" href="<?php $listing->the_permalink(); ?>">
														<?php echo esc_html__( 'Details', 'homlisti-core' ); ?>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
									<?php endif; ?>
                                </div>
                            </div>
                        </div>
					<?php endwhile; ?>
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			<?php endforeach; ?>
        </div>
    </div>
	<?php
if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
	?>
    <script>jQuery( '.featuredContainer' ).isotope();</script>
	<?php
}