<?php

if ( ! defined( 'ABSPATH' ) ) {
	// Exit if accessed directly.
	exit;
}

/**
 * Handling all the AJAX calls in WP Analytify
 *
 * @since 1.2.4
 * @class WPANALYTIFY_AJAX
 */
class WPANALYTIFY_AJAX {

	protected static $show_settings = array();

	public static function init() {


		$_analytify_dashboard = get_option( 'wp-analytify-dashboard' );
		if (  $_analytify_dashboard &&	 array_key_exists( 'show_analytics_panels_dashboard', $_analytify_dashboard ) ) {
			self::$show_settings = $_analytify_dashboard['show_analytics_panels_dashboard'];
		}

		$ajax_calls = array(
			'rated'	=> false,
			'load_general_stats' => false,
			'load_default_general_stats' => false,
			'load_top_pages' => false,
			'load_default_top_pages' => false,
			'load_country_stats' => false,
			'load_city_stats' => false,
			'load_keyword_stats' => false,
			'load_social_stats' => false,
			'load_browser_stats' => false,
			'load_os_stats' => false,
			'load_referrer_stats' => false,
			'load_page_exit_stats' => false,
			'fetch_log' => false,
			'load_default_geographic' => false,
			'load_default_system' => false,
			'load_default_keyword' => false,
			'load_default_page' => false,
			'load_default_social_media' => false,
			'load_default_reffers' => false,
			'dismiss_pointer'	=> true,
			'remove_comparison_gif' => false,
			'deactivate' => true,
			'optin_yes' => false,
			'optout_yes' => false,
			'optin_skip' => false,
			'export_settings' => false,
			'import_settings' => false,
			);

		foreach ( $ajax_calls as $ajax_call => $no_priv ) {
			// code...
			add_action( 'wp_ajax_analytify_' . $ajax_call, array( __CLASS__, $ajax_call ) );

			if ( $no_priv ) {
				add_action( 'wp_ajax_nopriv_analytify_' . $ajax_call, array( __CLASS__, $ajax_call ) );
			}
		}
	}

	/**
	 * Triggered when clicking the rating footer.
	 *
	 * @since 1.2.4
	 */
	public static function rated() {

		update_option( 'analytify_admin_footer_text_rated', 1 );
		die( 'rated' );
	}


	public static function load_general_stats() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		$compare_start_date = $_GET['compare_start_date'];
		$compare_end_date   = $_GET['compare_end_date'];
		$date_different =  $_GET['date_different'];




		if ( is_array( self::$show_settings ) and in_array( 'show-overall-dashboard', self::$show_settings ) ) {

			$stats = get_transient( md5( 'show-overall-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if( $stats === false ) {
				$stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions,ga:bounceRate,ga:newUsers,ga:entrances,ga:pageviews,ga:avgSessionDuration,ga:sessionDuration,ga:avgTimeOnPage,ga:users', $start_date, $end_date );
				set_transient( md5( 'show-overall-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $stats, 60 * 60 * 20 );

			}

			// get prev stats
			$compare_stats =  get_transient( md5( 'show-overall-dashboard-compare' . $dashboard_profile_ID . $compare_start_date . $compare_end_date ) );
			// if ( false === $compare_stats ) {
				$compare_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions,ga:bounceRate,ga:users', $compare_start_date, $compare_end_date );
				set_transient( md5( 'show-overall-dashboard-compare' . $dashboard_profile_ID . $start_date . $end_date ) , $stats, 60 * 60 * 20 );
			// }

			if ( isset( $stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH . '/views/old/admin/general-stats.php';
				pa_include_general( $wp_analytify , $stats , $compare_stats , $date_different );
			}
		}

		die();
	}

	public static function load_default_general_stats() {

		check_ajax_referer( 'analytify-get-dashboard-stats', 'nonce' );

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		$compare_start_date = $_GET['compare_start_date'];
		$compare_end_date   = $_GET['compare_end_date'];
		$date_different     = $_GET['date_different'];

		$stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions,ga:users,ga:pageviews,ga:avgSessionDuration,ga:bounceRate,ga:pageviewsPerSession,ga:percentNewSessions,ga:newUsers,ga:sessionDuration', $start_date, $end_date, false, false, false, false, 'show-default-overall-dashboard' );

		// New vs Returning Users
		$new_returning_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:users', $start_date, $end_date, 'ga:userType', false, false, false, 'show-default-new-returning-dashboard' );

		// Device Category Stats
		$device_category_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:deviceCategory', '-ga:sessions',  false, false, 'show-default-overall-device-dashboard' );


		// get prev stats
		$compare_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions,ga:users,ga:pageviews,ga:avgSessionDuration,ga:bounceRate,ga:pageviewsPerSession,ga:percentNewSessions,ga:newUsers', $compare_start_date, $compare_end_date, false, false, false, false, 'show-default-overall-dashboard-compare' );


			if ( isset( $stats->totalsForAllResults ) ) {

				include ANALYTIFY_ROOT_PATH . '/views/default/admin/general-stats.php';
				fetch_general_stats( $wp_analytify , $stats , $device_category_stats, $compare_stats , $date_different, $new_returning_stats );
			}


		die();
	}



	public static function load_top_pages() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		if ( is_array( self::$show_settings ) and in_array( 'show-top-pages-dashboard', self::$show_settings ) ) {

			$top_page_stats = get_transient( md5( 'show-top-pages-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if ( $top_page_stats === false ) {
				$top_page_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:pageviews', $start_date, $end_date, 'ga:PageTitle', '-ga:pageviews', false, 5 );
				set_transient( md5( 'show-top-pages-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $top_page_stats, 60 * 60 * 20 );
			}

			if ( isset( $top_page_stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH . '/views/old/admin/top-pages-stats.php';
				pa_include_top_pages_stats( $wp_analytify, $top_page_stats );
			}
		}

		die();
	}

	public static function load_default_top_pages(){

		check_ajax_referer( 'analytify-get-dashboard-stats', 'nonce' );

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		$top_page_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:pageviews,ga:avgTimeOnPage,ga:bounceRate', $start_date, $end_date, 'ga:PageTitle,ga:pagePath', '-ga:pageviews', false, 40, 'show-default-top-pages-dashboard' );

		if ( $top_page_stats ) {
			include ANALYTIFY_ROOT_PATH . '/views/default/admin/top-pages-stats.php';
			fetch_top_pages_stats( $wp_analytify, $top_page_stats );
		}

		wp_die( );
	}



	public static function load_country_stats() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		if ( is_array( self::$show_settings ) and in_array( 'show-country-dashboard', self::$show_settings ) ) {

			$country_stats = get_transient( md5( 'show-country-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if ( $country_stats === false ) {
				$country_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:country', '-ga:sessions', false, 5 );
				set_transient( md5( 'show-country-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $country_stats, 60 * 60 * 20 );
			}

			if ( isset( $country_stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH . '/views/old/admin/country-stats.php';
				pa_include_country( $wp_analytify,$country_stats );
			}
		}

		die();
	}


	public static function load_city_stats() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		if ( is_array( self::$show_settings ) and in_array( 'show-city-dashboard', self::$show_settings ) ) {

			$city_stats = get_transient( md5( 'show-city-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if ( $city_stats === false ) {
				$city_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:city', '-ga:sessions', false, 5 );
				set_transient( md5( 'show-city-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $city_stats, 60 * 60 * 20 );
			}

			if ( isset( $city_stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH . '/views/old/admin/city-stats.php';
				pa_include_city( $wp_analytify,$city_stats );
			}
		}

		die();
	}

	public static function load_keyword_stats() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		if ( is_array( self::$show_settings ) and in_array( 'show-keywords-dashboard', self::$show_settings ) ) {

			$keyword_stats = get_transient( md5( 'show-keywords-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if ( $keyword_stats === false ) {
				$keyword_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:keyword', '-ga:sessions', false, 10 );
				set_transient( md5( 'show-keywords-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $keyword_stats, 60 * 60 * 20 );
			}

			if ( isset( $keyword_stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH . '/views/old/admin/keywords-stats.php';
				pa_include_keywords( $wp_analytify,$keyword_stats );
			}
		}

		die();
	}


	public static function load_social_stats() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		if ( is_array( self::$show_settings ) and in_array( 'show-social-dashboard', self::$show_settings ) ) {

			$social_stats = get_transient( md5( 'show-social-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if ( $social_stats === false ) {
				$social_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:socialNetwork', '-ga:sessions', false, 10 );
				set_transient( md5( 'show-social-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $social_stats, 60 * 60 * 20 );
			}

			if ( isset( $social_stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH . '/views/old/admin/social-stats.php';
				pa_include_social( $wp_analytify, $social_stats );
			}
		}

		die();
	}


	public static function load_browser_stats() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		if ( is_array( self::$show_settings ) and in_array( 'show-browser-dashboard', self::$show_settings ) ) {

			$browser_stats = get_transient( md5( 'show-browser-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if ( $browser_stats === false ) {
				$browser_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:browser,ga:operatingSystem', '-ga:sessions',false,5 );
				set_transient( md5( 'show-browser-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $browser_stats, 60 * 60 * 20 );
			}

			if ( isset( $browser_stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH . '/views/old/admin/browser-stats.php';
				pa_include_browser( $wp_analytify,$browser_stats );
			}
		}

		die();
	}

	public static function load_os_stats() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		if ( is_array( self::$show_settings ) and in_array( 'show-os-dashboard', self::$show_settings ) ) {

			$operating_stats = get_transient( md5( 'show-os-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if ( $operating_stats === false ) {
				$operating_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:operatingSystem,ga:operatingSystemVersion', '-ga:sessions', false, 5 );
				set_transient( md5( 'show-os-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $operating_stats, 60 * 60 * 20 );
			}

			$operating_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:operatingSystem,ga:operatingSystemVersion', '-ga:sessions', false, 5 );
			if ( isset( $city_stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH . '/views/old/admin/os-stats.php';
				pa_include_operating( $wp_analytify, $operating_stats );
			}
		}

		die();
	}


	public static function load_referrer_stats() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		if ( is_array( self::$show_settings ) and in_array( 'show-referrer-dashboard', self::$show_settings ) ) {

			$referr_stats = get_transient( md5( 'show-referrer-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if ( $referr_stats === false ) {
				$referr_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:source,ga:medium', '-ga:sessions', false, 10 );
				set_transient( md5( 'show-referrer-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $referr_stats, 60 * 60 * 20 );
			}

			if ( isset( $referr_stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH.'/views/old/admin/referrers-stats.php';
				pa_include_referrers( $wp_analytify, $referr_stats );
			}
		}

		die();
	}


	public static function load_page_exit_stats() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		if ( is_array( self::$show_settings ) and in_array( 'show-page-stats-dashboard', self::$show_settings ) ) {

			$page_stats = get_transient( md5( 'show-page-stats-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) );
			if ( $page_stats === false ) {
				$page_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:entrances,ga:pageviews,ga:exits', $start_date, $end_date, 'ga:PagePath', '-ga:exits', 'ga:pageTitle!=(not set)', 5 );
				set_transient( md5( 'show-page-stats-dashboard' . $dashboard_profile_ID . $start_date . $end_date ) , $page_stats, 60 * 60 * 20 );
			}

			if ( isset( $page_stats->totalsForAllResults ) ) {
				include ANALYTIFY_ROOT_PATH . '/views/old/admin/pages-stats.php';
				pa_include_pages_stats( $wp_analytify, $page_stats );
			}
		}

		die();
	}

	public static function load_default_geographic() {

		check_ajax_referer( 'analytify-get-dashboard-stats', 'nonce' );

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];
		$report_url           = $_GET['report_url'];
		$report_date_range    = $_GET['report_date_range'];

		$countries_stats 	= $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date , 'ga:country' , '-ga:sessions' , 'ga:country!=(not set)', false, 'show-geographic-countries-dashboard' );

		$cities_stats 		= $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date , 'ga:city,ga:country' , '-ga:sessions' , 'ga:city!=(not set);ga:country!=(not set)', 5, 'show-geographic-cities-dashboard' );

		if ( $countries_stats ) {
			include ANALYTIFY_ROOT_PATH . '/views/default/admin/geographic-stats.php';
			fetch_geographic_stats( $wp_analytify, $countries_stats, $cities_stats, true, $report_url, $report_date_range );
		}

		wp_die( );
	}

	public static function load_default_system() {

		check_ajax_referer( 'analytify-get-dashboard-stats', 'nonce' );

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		$browser_stats 	= $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date , 'ga:browser,ga:operatingSystem' , '-ga:sessions' , 'ga:browser!=(not set);ga:operatingSystem!=(not set)', 5, 'show-default-browser-dashboard' );
		$os_stats 			= $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date , 'ga:operatingSystem,ga:operatingSystemVersion' , '-ga:sessions' , 'ga:operatingSystemVersion!=(not set)', 5, 'show-default-os-dashboard' );
		$mobile_stats 	= $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date , 'ga:mobileDeviceBranding,ga:mobileDeviceModel' , '-ga:sessions', 'ga:mobileDeviceModel!=(not set);ga:mobileDeviceBranding!=(not set)', 5, 'show-default-mobile-dashboard' );


		if ( $browser_stats ) {
			include ANALYTIFY_ROOT_PATH . '/views/default/admin/system-stats.php';
			fetch_system_stats( $wp_analytify, $browser_stats, $os_stats, $mobile_stats );
		}

		wp_die();
	}

	public static function load_default_keyword() {

		check_ajax_referer( 'analytify-get-dashboard-stats', 'nonce' );

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		$keyword_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:keyword', '-ga:sessions', false, 8, 'show-default-keyword-dashboard' );

		if ( $keyword_stats ) {
			include ANALYTIFY_ROOT_PATH . '/views/default/admin/keywords-stats.php';
			fetch_keywords_stats( $wp_analytify, $keyword_stats );
		}

		wp_die();
	}

	public static function load_default_page() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		$page_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:entrances,ga:exits,ga:entranceRate,ga:exitRate', $start_date, $end_date , 'ga:pageTitle,ga:pagePath' , '-ga:entrances' , false, 5, 'show-default-pages-dashboard' );

		if ( $page_stats ) {
			include ANALYTIFY_ROOT_PATH . '/views/default/admin/pages-stats.php';
			fetch_pages_stats( $wp_analytify, $page_stats );
		}

		wp_die();

	}

	public static function load_default_social_media() {

		check_ajax_referer( 'analytify-get-dashboard-stats', 'nonce' );

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		$social_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:socialNetwork', '-ga:sessions', 'ga:socialNetwork!=(not set)', 7, 'show-default-social-dashboard' );


		if ( $social_stats ) {
			include ANALYTIFY_ROOT_PATH . '/views/default/admin/socialmedia-stats.php';
			fetch_socialmedia_stats( $wp_analytify, $social_stats );
		}

		wp_die( );

	}

	public static function load_default_reffers() {

		$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
		$dashboard_profile_ID = $_GET['dashboard_profile_ID'];
		$start_date           = $_GET['start_date'];
		$end_date             = $_GET['end_date'];

		$referr_stats = $wp_analytify->pa_get_analytics_dashboard( 'ga:sessions', $start_date, $end_date, 'ga:source,ga:medium', '-ga:sessions', false, 7, 'show-default-reffers-dashboard' );

		if ( $referr_stats ) {
			include ANALYTIFY_ROOT_PATH . '/views/default/admin/referrers-stats.php';
			fetch_referrers_stats( $wp_analytify, $referr_stats );
		}

		wp_die();

	}

	static function fetch_log() {

		check_ajax_referer( 'fetch-log', 'nonce' );

		ob_start();

		self::output_diagnostic_info();
		
		echo ob_get_clean();

		wp_die();
	}


	/**
	 * Outputs diagnostic info for debugging.
	 *
	 * Outputs useful diagnostic info text at the Diagnostic Info & Error Log
	 * section under the Help tab so the information can be viewed or
	 * downloaded and shared for debugging.
	 *
	 * If you would like to add additional diagnostic information use the
	 * `wpanalytify_diagnostic_info` action hook (see {@link https://developer.wordpress.org/reference/functions/add_action/}).
	 *
	 * <code>
	 * add_action( 'wpanalytify_diagnostic_info', 'my_diagnostic_info' ) {
	 *     echo "Additional Diagnostic Info: \r\n";
	 *     echo "...\r\n";
	 * }
	 * </code>
	 *
	 * @return void
	 */
	static function output_diagnostic_info() {
		global $wpdb;
		$table_prefix = $wpdb->base_prefix;
		$authentication_date = get_option( 'analytify_authentication_date' );

		echo "-- System Information --\r\n \r\n";

		echo 'site_url(): ';
		echo esc_html( site_url() );
		echo "\r\n";

		echo 'home_url(): ';
		echo esc_html( home_url() );
		echo "\r\n";

		echo 'WordPress: ';
		echo bloginfo( 'version' );
		if ( is_multisite() ) {
			echo ' Multisite';
		}
		echo "\r\n";

		echo 'Web Server: ';
		echo esc_html( ! empty( $_SERVER['SERVER_SOFTWARE'] ) ? $_SERVER['SERVER_SOFTWARE'] : '' );
		echo "\r\n";

		echo 'PHP: ';
		if ( function_exists( 'phpversion' ) ) {
			echo esc_html( phpversion() );
		}
		echo "\r\n";

		echo 'MySQL: ';
		echo esc_html( empty( $wpdb->use_mysqli ) ? mysql_get_server_info() : mysqli_get_server_info( $wpdb->dbh ) );
		echo "\r\n";

		echo 'ext/mysqli: ';
		echo empty( $wpdb->use_mysqli ) ? 'no' : 'yes';
		echo "\r\n";

		echo 'WP Memory Limit: ';
		echo esc_html( WP_MEMORY_LIMIT );
		echo "\r\n";

		echo 'Blocked External HTTP Requests: ';
		if ( ! defined( 'WP_HTTP_BLOCK_EXTERNAL' ) || ! WP_HTTP_BLOCK_EXTERNAL ) {
			echo 'None';
		} else {
			$accessible_hosts = ( defined( 'WP_ACCESSIBLE_HOSTS' ) ) ? WP_ACCESSIBLE_HOSTS : '';

			if ( empty( $accessible_hosts ) ) {
				echo 'ALL';
			} else {
				echo 'Partially (Accessible Hosts: ' . esc_html( $accessible_hosts ) . ')';
			}
		}
		echo "\r\n";

		echo 'WP Locale: ';
		echo esc_html( get_locale() );
		echo "\r\n";

		echo 'DB Charset: ';
		echo esc_html( DB_CHARSET );
		echo "\r\n";

		if ( function_exists( 'ini_get' ) && $suhosin_limit = ini_get( 'suhosin.post.max_value_length' ) ) {
			echo 'Suhosin Post Max Value Length: ';
			echo esc_html( is_numeric( $suhosin_limit ) ? size_format( $suhosin_limit ) : $suhosin_limit );
			echo "\r\n";
		}

		if ( function_exists( 'ini_get' ) && $suhosin_limit = ini_get( 'suhosin.request.max_value_length' ) ) {
			echo 'Suhosin Request Max Value Length: ';
			echo esc_html( is_numeric( $suhosin_limit ) ? size_format( $suhosin_limit ) : $suhosin_limit );
			echo "\r\n";
		}

		echo 'Debug Mode: ';
		echo esc_html( ( defined( 'WP_DEBUG' ) && WP_DEBUG ) ? 'Yes' : 'No' );
		echo "\r\n";

		echo 'WP Max Upload Size: ';
		echo esc_html( size_format( wp_max_upload_size() ) );
		echo "\r\n";

		echo 'PHP Time Limit: ';
		if ( function_exists( 'ini_get' ) ) {
			echo esc_html( ini_get( 'max_execution_time' ) );
		}
		echo "\r\n";

		echo 'PHP Error Log: ';
		if ( function_exists( 'ini_get' ) ) {
			echo esc_html( ini_get( 'error_log' ) );
		}
		echo "\r\n";

		echo 'fsockopen: ';
		if ( function_exists( 'fsockopen' ) ) {
			echo 'Enabled';
		} else {
			echo 'Disabled';
		}
		echo "\r\n";

		echo 'OpenSSL: ';
		if ( defined( 'OPENSSL_VERSION_TEXT' ) ) {
			echo esc_html( OPENSSL_VERSION_TEXT );
		} else {
			echo 'Disabled';
		}
		echo "\r\n";

		echo 'cURL: ';
		if ( function_exists( 'curl_init' ) ) {
			echo 'Enabled';
		} else {
			echo 'Disabled';
		}
		if ( function_exists( 'curl_version' ) ) {
			$_curl = curl_version();
			echo ' (' . $_curl['version'] . ' ' . $_curl['ssl_version'] . ')';
		}
		echo "\r\n";

		$theme_info = wp_get_theme();
		echo 'Active Theme Name: ' . esc_html( $theme_info->Name ) . "\r\n";
		echo 'Active Theme Folder: ' . esc_html( basename( $theme_info->get_stylesheet_directory() ) ) . "\r\n";
		if ( $theme_info->get( 'Template' ) ) {
			echo 'Parent Theme Folder: ' . esc_html( $theme_info->get( 'Template' ) ) . "\r\n";
		}
		if ( ! file_exists( $theme_info->get_stylesheet_directory() ) ) {
			echo "WARNING: Active Theme Folder Not Found\r\n";
		}

		echo "\r\n";

		echo "-- Active Plugins --\r\n \r\n";

		$active_plugins = (array) get_option( 'active_plugins', array() );

		if ( is_multisite() ) {
			$network_active_plugins = wp_get_active_network_plugins();
			$active_plugins         = array_map( array( 'WPANALYTIFY_Utils', 'remove_wp_plugin_dir' ), $network_active_plugins );
		}

		foreach ( $active_plugins as $plugin ) {
			$suffix = '';
			self::print_plugin_details( WP_PLUGIN_DIR . '/' . $plugin, $suffix );
		}

		$mu_plugins = wp_get_mu_plugins();
		if ( $mu_plugins ) {
			echo "\r\n";

			echo "-- Must-use Plugins --\r\n \r\n";

			foreach ( $mu_plugins as $mu_plugin ) {
				self::print_plugin_details( $mu_plugin );
			}
		}

		echo "\r\n";

		if ( class_exists( 'WP_Analytify_Pro_Base' ) ) {

			$analytify_active_modules = [];

			$analytify_modules = get_option( 'wp_analytify_modules' );

			foreach ( $analytify_modules as $module ) {
				if ( 'active' === $module['status'] ) {
					$analytify_active_modules[] = $module['title'];
				}
			}

			echo "-- Active Modules --\r\n \r\n";

			if ( $analytify_active_modules ) {
				foreach ( $analytify_active_modules as $analytify_module ) {
					printf( "%s \r\n", $analytify_module );
				}
			} else {
				echo "- None - \r\n";
			}

			echo "\r\n";

		}

		if ( ! empty( $authentication_date ) ) {
			echo "-- Last Authenticated --\r\n \r\n";
			echo "$authentication_date \r\n";
			echo "\r\n";
		}

		echo "-- Analytify Profile Setting --\r\n \r\n";

		$analytify_profile = get_option( 'wp-analytify-profile' );

		WPANALYTIFY_Utils::print_settings_array( $analytify_profile );

		// print_r( $analytify_profile );

		echo "\r\n";


		echo "-- Analytify Front Setting --\r\n \r\n";

		$analytify_front = get_option( 'wp-analytify-front' );

		WPANALYTIFY_Utils::print_settings_array( $analytify_front );

		echo "\r\n";

		echo "-- Analytify Admin Setting --\r\n \r\n";

		$analytify_admin = get_option( 'wp-analytify-admin' );

		WPANALYTIFY_Utils::print_settings_array( $analytify_admin );

		echo "\r\n";

		echo "-- Analytify Dashboard Setting --\r\n \r\n";

		$analytify_dashboard = get_option( 'wp-analytify-dashboard' );

		WPANALYTIFY_Utils::print_settings_array( $analytify_dashboard );
	
		echo "\r\n";

		do_action( 'analytify_settings_logs' );

		echo "\r\n";
		
		echo "-- Analytify Advance Setting --\r\n \r\n";

		$analytify_advance = get_option( 'wp-analytify-advanced' );
		// if keys not set, show default.
		if ( ! isset( $analytify_advance['user_advanced_keys'] ) || $analytify_advance['user_advanced_keys'] == 'off' ) {

			// set as array if its string.
			if ( ! is_array( $analytify_advance ) ) { $analytify_advance = array(); }

			$analytify_advance['client_id'] = ANALYTIFY_CLIENTID;
			$analytify_advance['client_secret'] = 'Hidden';
		}

		WPANALYTIFY_Utils::print_settings_array( $analytify_advance );
	}

	function output_log_file() {
			$this->load_error_log();
		if ( isset( $this->error_log ) ) {
			echo $this->error_log;
		}
	}

	static function print_plugin_details( $plugin_path, $suffix = '' ) {
		$plugin_data = get_plugin_data( $plugin_path );
		if ( empty( $plugin_data['Name'] ) ) {
			return;
		}

		printf( "%s%s (v%s) by %s\r\n", $plugin_data['Name'], $suffix, $plugin_data['Version'], $plugin_data['AuthorName'] );
	}

	/**
	 * Triggered when clicking the dismiss button.
	 * @since 1.0.8
	 */
	public static function dismiss_pointer() {

		$wpa_allow  = isset($_POST['wpa_allow']) ? $_POST['wpa_allow']: 0;

		if( $wpa_allow == 1 ) {

			update_option('wpa_allow_tracking', 1);
			send_status_analytify( get_option( 'admin_email' ), 'active');
		}

		update_option('show_tracking_pointer_1', 1);
		die();
	}

	/**
	 * Remove Gif Add
	 *
	 * @since 2.0.11
	 */
	public static function remove_comparison_gif() {
		update_option( 'analytify_remove_comparison_gif', 'yes' );
		wp_die();
	}

	public static function  deactivate() {

		$email         = get_option( 'admin_email' );
		$_reason       = sanitize_text_field( wp_unslash( $_POST['reason'] ) );
		$reason_detail = sanitize_text_field( wp_unslash( $_POST['reason_detail'] ) );
		$reason        = '';

		if ( $_reason == '1' ) {
			$reason = 'I only needed the plugin for a short period';
		} elseif ( $_reason == '2' ) {
			$reason = 'I found a better plugin';
		} elseif ( $_reason == '3' ) {
			$reason = 'The plugin broke my site';
		} elseif ( $_reason == '4' ) {
			$reason = 'The plugin suddenly stopped working';
		} elseif ( $_reason == '5' ) {
			$reason = 'I no longer need the plugin';
		} elseif ( $_reason == '6' ) {
			$reason = 'It\'s a temporary deactivation. I\'m just debugging an issue.';
		} elseif ( $_reason == '7' ) {
			$reason = 'Other';
		}

		$fields = array(
			'action'            => 'Deactivate',
			'reason'            => $reason,
			'reason_detail'     => $reason_detail,
		);

		analytify_send_data( $fields );

		wp_die();
	}


	// Add opt-in bacon
	public static function optin_yes() {

		// Track in user database
		update_site_option( '_analytify_optin', 'yes' );

		$fields = array(
			'action'	=>	'Activate',
			'track_mailchimp' =>	'yes'
			);
		analytify_send_data( $fields );
		wp_die();
	}

	// Delete opt-in bacon
	public static function optout_yes() {
		update_site_option( '_analytify_optin', 'no' );
		wp_die();
	}

	// Optin skip.
	public static function optin_skip() {

		update_site_option( '_analytify_optin', 'no' );

		$fields = array(
			'action'	=>	'Skip',
		);
		analytify_send_data( $fields );
		wp_die();
	}

	/**
	 * Create json file for export settings.
	 *
	 * @return string
	 */
	public static function export_settings() {

		check_ajax_referer( 'import-export', 'nonce' );

		$profile_settings = get_option( 'wp-analytify-profile' );

		// Remove authentication values.
		unset($profile_settings['profile_for_posts']);
		unset($profile_settings['profile_for_dashboard']);
		unset($profile_settings['hide_profiles_list']);

		$settings = array(
			'wp-analytify-profile' => $profile_settings,
			'wp-analytify-admin' => get_option( 'wp-analytify-admin' ),
			'wp-analytify-advanced' => get_option( 'wp-analytify-advanced' ),
			'wp-analytify-email' => get_option( 'wp-analytify-email' ),
		);

		if ( class_exists( 'WP_Analytify_Pro_Base' ) ) {
			$settings['wp-analytify-front'] = get_option( 'wp-analytify-front' );
			$settings['wp-analytify-dashboard'] = get_option( 'wp-analytify-dashboard' );
			$settings['wp-analytify-events-tracking'] = get_option( 'wp-analytify-events-tracking' );
			$settings['wp-analytify-custom-dimensions'] = get_option( 'wp-analytify-custom-dimensions' );
			$settings['wp-analytify-google-optimize'] = get_option( 'wp-analytify-google-optimize' );
		}

		if ( class_exists( 'Analytify_Forms' ) ) {
			$settings['wp-analytify-forms'] = get_option( 'wp-analytify-forms' );
		}

		$settings = json_encode( $settings );

		echo $settings;

		wp_die();
	}

	/**
	 * Transfer json file data to settings.
	 *
	 * @return string
	 */
    public static function import_settings() {

		check_ajax_referer( 'import-export', 'nonce' );

		if ( ! current_user_can( 'manage_options' ) ) {
		  wp_die( 'No cheating, huh!' );
		}
  
		$imp_tmp_name =  $_FILES['file']['tmp_name'];

		$file_content = file_get_contents( $imp_tmp_name );
		$settings_json = json_decode( $file_content, true );
  
		if ( json_last_error() !== JSON_ERROR_NONE ) {
			echo 'failed';
		}

		foreach ( $settings_json as $setting => $value_array ) {
			$old_value_array = get_option( $setting );

			if ( ! empty( $value_array ) ) {
				if ( 'wp-analytify-profile' === $setting && ! empty( $old_value_array ) ) { // For profile tab settings update except authentication values. 
					$old_value_array['install_ga_code'] = $value_array['install_ga_code'];
					$old_value_array['exclude_users_tracking'] = $value_array['exclude_users_tracking'];
					update_option( $setting, $old_value_array );
				} else { // Update whole settings tab array.
					update_option( $setting, $value_array );
				}
			}
		}

		echo 'success';
		wp_die();
	}

} // End of WPANALYTIFY_AJAX .

function wp_analytify_ajax_load() {

	return WPANALYTIFY_AJAX::init();
}

$GLOBALS['WPANALYTIFY_AJAX'] = wp_analytify_ajax_load();
